/* sendto.c (emx+gcc) -- Copyright (c) 1994-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/types.h>
#include <sys/socket.h>

int sendto (int handle, const void *buf, int len, int flags,
            const struct sockaddr *to, int tolen)
{
  struct _sendto args;

  args.handle = handle;
  args.buf    = buf;
  args.len    = len;
  args.flags  = flags;
  if (to->sa_family != AF_UNIX)
    args.to     = to;
  else
    if (__udsockpath (to, &args.to) < 0)
      return -1;
  args.tolen  = tolen;
  return __sendto (&args);
}
