/* recvfrom.c (emx+gcc) -- Copyright (c) 1994-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/types.h>
#include <sys/socket.h>

int recvfrom (int handle, void *buf, int len, int flags,
              struct sockaddr *from, int *pfromlen)
{
  struct _recvfrom args;

  args.handle   = handle;
  args.buf      = buf;
  args.len      = len;
  args.flags    = flags;
  if (from->sa_family != AF_UNIX)
    args.from   = from;
  else
    if (__udsockpath (from, &args.from) < 0)
      return -1;
  args.pfromlen = pfromlen;
  return __recvfrom (&args);
}
