/* bind.c (emx+gcc) -- Copyright (c) 1994-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/types.h>
#include <sys/socket.h>

int bind (int handle, const struct sockaddr *addr, int addrlen)
{
  struct sockaddr* sa;

  /* Fix path name for OS/2 */
  if (addr->sa_family == AF_UNIX)
  {
    if (__udsockpath (addr, &sa) < 0)
      return -1;
    return __bind (handle, sa, addrlen);
  }
  else
    return __bind (handle, addr, addrlen);
}
