/* udmkpath.c (emx+gcc) -- Copyright (c) 1996 Robert Muchsel */

#include <sys/emx.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

int __udsockpath(struct sockaddr_un *in, struct sockaddr_un **out)
{
  static struct sockaddr_un un;
  int i;

  /* Fix path name and ignore addrlen for OS/2 */
  if (in->sun_family == AF_UNIX)
  {
    un.sun_family = AF_UNIX;

    /* Check for mandatory \SOCKET\ prefix and construct absolute path name */
    if (((in->sun_path[0] == '/') 
       ||(in->sun_path[0] == '\\'))
      &&((in->sun_path[8] == '/') 
       ||(in->sun_path[8] == '\\'))
      &&(strnicmp(in->sun_path+1, "SOCKET", 6) == 0))
    {
      strncpy(un.sun_path, in->sun_path, 108);
    } else {
      if (_abspath (un.sun_path+8, in->sun_path, 108-8) < 0)
        return -1;
      memcpy(un.sun_path, "\\SOCKET\\", 8);
    }

    /* Translate slashes */
    for (i = 0; i < 108 && un.sun_path[i]; i++)
      if (un.sun_path[i] == '/')
        un.sun_path[i] = '\\';
      else if (un.sun_path[i] == ':')
        un.sun_path[i] = '_';
    
    *out = &un;
  }
  else
    *out = in;

  return 0;
}