/* fcntl.c (emx+gcc) -- Copyright (c) 1992-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <unistd.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#define FLAGS (O_APPEND | O_NDELAY)

/* Create a new file descriptor for HANDLE that is the lowest numbered
   available file descriptor greater than or equal to HANDLE2. */

static int dupfd (int handle, int handle2)
{
  int *handles;
  int n, fd, e;

  handles = alloca (handle2 * sizeof (int));
  n = 0;
  for (;;)
    {
      fd = _dup (handle);
      if (fd < 0 || fd >= handle2)
        break;
      if (n >= handle2)
        {
          /* Avoid writing beyond the end of handles[] if dup()
             happens not to work as advertised. */

          _close (fd);
          fd = -1; errno = EMFILE;
          break;
        }
      handles[n++] = fd;
    }
  e = errno;
  while (n > 0)
    _close (handles[--n]);
  errno = e;
  return fd;
}


int _fcntl (int handle, int request, int arg)
{
  int i;

  if (handle < 0 || handle >= _nfiles ||
      _ioctl (handle, FGETHTYPE, &i) < 0)
    {
      errno = EBADF;
      return -1;
    }
  switch (request)
    {
    case F_GETFL:
      return _files[handle] & FLAGS;
    case F_SETFL:
      if (arg & ~FLAGS)
        break;
      if (__fcntl (handle, request, arg) == -1)
        return -1;
      SETBITS (_files[handle], FLAGS, arg);
      return 0;
    case F_GETFD:
    case F_SETFD:
      return __fcntl (handle, request, arg);
    case F_DUPFD:
      if (arg < 0 || arg >= _nfiles)
        {
          errno = EINVAL;
          return -1;
        }
      return dupfd (handle, arg);
    }
  errno = EINVAL;
  return -1;
}
