/*

   Copyright (c) 1996 Robert Muchsel <muchsel@acm.org>.
   All rights reserved.

   socketpair() for OS/2

*/

#include <sys/emx.h>
#define INCL_DOSQUEUES
#define INCL_DOSERRORS
#include <os2emx.h>
#include <sys/errno.h>
#include "syscalls.h"
#include <stdio.h>
#include <io.h>
#include <share.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/fcntl.h>


extern int _pipe_size;
extern int _fmode_bin;


int __npipe (int *two_handles, int pipe_size, char *pipename)
{
  ULONG rc;

  rc = DosCreateNPipe (pipename,                /* Name of pipe to create */
                       (PHPIPE)&two_handles[0], /* Handle returned for pipe */
                       NP_ACCESS_DUPLEX |       /* Duplex pipe */
                       NP_INHERIT,              /* Inherit pipe to child processes */
                       NP_NOWAIT |              /* Non-blocking mode */
                       NP_TYPE_BYTE |           /* Pipe is byte stream */
                       NP_READMODE_BYTE |       /* Read byte stream */
                       0x01,                    /* Unique instance of pipe */
                       pipe_size,               /* Output buffer size */
                       pipe_size,               /* Input buffer size */
                       0L);                     /* Use default time-out */
  if (rc != 0)
    goto failrc;

  rc = DosConnectNPipe ((HPIPE)two_handles[0]);
  if ((rc != 0) && (rc != ERROR_PIPE_NOT_CONNECTED))
    goto fail0;

  two_handles[1] = __open (pipename, O_RDWR|SH_DENYRW, 0);
  if (two_handles[1] < 0)
    return -1;

  rc = DosSetNPHState ((HPIPE)two_handles[0], NP_WAIT | NP_READMODE_BYTE);
  if (rc != 0)
    goto fail;

  rc = DosConnectNPipe ((HPIPE)two_handles[0]);
  if (rc != 0)
    goto fail;

  return 0;

fail:
  __close (two_handles[1]);
fail0:
  __close (two_handles[0]);
failrc:
  _sys_set_errno (rc);
  return -1;
}


int s_pipe (int *two_handles)
{
  char tmp[255];

  strcpy (tmp, "\\PIPE\\SOCKXXXXXX");
  if (mktemp (tmp) == NULL) {
    errno = EMFILE;
    return -1;
  }

  if (__npipe (two_handles, (_pipe_size != 0 ? _pipe_size : 8192), tmp) != 0)
    return -1;
  if (two_handles[0] >= _nfiles || two_handles[1] >= _nfiles)
    {
      __close (two_handles[0]);
      __close (two_handles[1]);
      errno = EMFILE;
      return -1;
    }
  _files[two_handles[0]] = O_RDWR | F_PIPE;
  _files[two_handles[1]] = O_RDWR | F_PIPE;
  if (_fmode_bin == 0)
  {
    _files[two_handles[0]] |= O_TEXT;
    _files[two_handles[1]] |= O_TEXT;
  }
  _lookahead[two_handles[0]] = -1;
  _lookahead[two_handles[1]] = -1;

  return 0;
}


int socketpair (int a_family, int s_type, int s_protocol, int s_fd[2])
{
  if ((a_family != AF_UNIX) ||
      ((s_type != SOCK_STREAM) && (s_type != SOCK_DGRAM)) ||
      (s_protocol != 0)) {
    errno = EOPNOTSUPP;
    return -1;
  }

  return s_pipe (s_fd);
}
