// KeyDlg.cpp
// David Aylesworth

#include "stdafx.h"
#include "WinKey.h"
#include "Key.h"
#include "KeyDlg.h"
#include "OptDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CKeyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg dialog

CKeyDlg::CKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKeyDlg)
	m_password = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyDlg)
	DDX_Control(pDX, IDC_EDIT3, m_response);
	DDX_Control(pDX, IDC_EDIT1, m_challenge);
	DDX_Text(pDX, IDC_EDIT2, m_password);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_OPTIONS, OnOptions)
	ON_BN_CLICKED(IDOK, OnCompute)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_WM_ACTIVATE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg message handlers

BOOL CKeyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// set window position
	int x = theApp.GetProfileInt("Location", "Left", 20);
	int y = theApp.GetProfileInt("Location", "Top", 20);
	SetWindowPos(NULL, x, y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
   
	// get autopaste flag
	m_autopaste = theApp.GetProfileInt("Settings", "AutoPaste", 1);
   
	// get autocopy flag   
	m_autocopy = theApp.GetProfileInt("Settings", "AutoCopy", 1);
   
	// get autodecrement flag
	m_autodecrement = theApp.GetProfileInt("Settings", "AutoDecrement", 0);
   
	// get autoclear flag
	m_autoclear = theApp.GetProfileInt("Settings", "AutoClear", 0);
   
	// get appendcrlf flag
	m_appendcrlf = theApp.GetProfileInt("Settings", "AppendCRLF", 0);
   
	// get algorithm
	CString alg = theApp.GetProfileString("Settings", "Algorithm", "MD5");
	m_algorithm = (alg == "MD5");
   
	if (!m_autopaste)
		m_challenge.SetWindowText(theApp.GetProfileString("Defaults", "Challenge", ""));
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CKeyDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKeyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CKeyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CKeyDlg::OnOptions() 
{
	COptionsDlg *dlg;
	dlg = new COptionsDlg(this);
	if (dlg)
		dlg->DoModal();
	delete dlg;
}

void CKeyDlg::OnCompute() 
{
    HCURSOR oldCursor = SetCursor(theApp.LoadStandardCursor(IDC_WAIT));
    UpdateData(TRUE);

    /* parse challenge */
    CString challenge;
    m_challenge.GetWindowText(challenge);
    int algorithm;
    int keynum;
    CString seed;
   
    if (!KeyParseChallenge(challenge, algorithm, keynum, seed)) {
        MessageBox("Invalid OTP challenge.", "Error", MB_ICONEXCLAMATION);
        if (m_autoclear) {
            m_password.Empty();
            UpdateData(FALSE);
        }
        m_challenge.SetFocus();
        m_challenge.SetSel(0, -1, TRUE);
        SetCursor(oldCursor);
        return;
    }

    if (algorithm == -1)
    algorithm = m_algorithm + 4;

    CString response;
	if (!KeyGenerateResponse(algorithm, keynum, seed, m_password, response)) {
        MessageBox("Key crunch failed.", "Error", MB_ICONEXCLAMATION);
        if (m_autoclear) {
            m_password.Empty();
            UpdateData(FALSE);
        }
        SetCursor(oldCursor);
        return;
    }

    if (m_autoclear) {
        // clear password
        m_password.Empty();
        UpdateData(FALSE);
    }
      
    if (m_autodecrement && keynum>0) {
        // decrement sequence #
        char buf[64];      
        sprintf(buf, "%s %d %s", (algorithm == 4) ? "otp-md4" : "otp-md5",
                keynum-1, seed);
        challenge = buf;
        m_challenge.SetWindowText(challenge);
    }
   
    theApp.WriteProfileString("Defaults", "Challenge", challenge);

    m_response.SetWindowText(response);
    m_response.SetFocus();
    m_response.SetSel(0, -1, TRUE);
    m_response.LineScroll(0);
    if (m_autocopy) {
        if (m_appendcrlf)
    	    response += "\r\n";
        if (OpenClipboard()) {
            EmptyClipboard();
            HANDLE handle = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,
                                        response.GetLength() + 1);
            char *s = (char *)GlobalLock(handle);
            strcpy(s, response);
            GlobalUnlock(handle);
            SetClipboardData(CF_TEXT, handle);
            CloseClipboard();
        }
    }

    SetCursor(oldCursor);
}

void CKeyDlg::OnActivate(UINT nState, CWnd *pWndOther, BOOL bMinimized)
{
    CWnd::OnActivate(nState, pWndOther, bMinimized);

    if (nState != WA_INACTIVE) {
        // set focus to challenge field
        m_challenge.SetFocus();
        m_challenge.SetSel(0, -1, TRUE);

        if (m_autopaste) {
            // paste clipboard text into challenge
            if (OpenClipboard()) {
                HANDLE handle = GetClipboardData(CF_TEXT);
                if (handle) {
                    CString s = (char *)GlobalLock(handle);
                    GlobalUnlock(handle);
                    CloseClipboard();
                    int algorithm, sequence;
                    CString seed;
                    if (KeyParseChallenge(s, algorithm, sequence, seed))
                        m_challenge.Paste();
                    m_challenge.SetSel(0, -1, TRUE);
                }
                CloseClipboard();
            }
        }
    }
}

void CKeyDlg::OnDestroy() 
{
    RECT rect;   
    GetWindowRect(&rect);
    theApp.WriteProfileInt("Location", "Left", rect.left);
    theApp.WriteProfileInt("Location", "Top", rect.top);

	CDialog::OnDestroy();
}
