/************************************************************************/
/*									*/
/*	MISC.C		"Miscellaneous C Functions"			*/
/*									*/
/*   This file contains miscellaneous functions used by the Initializer	*/
/* demonstration program.						*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/

/************************************************************************/
/* Necessary header files:						*/
/************************************************************************/
#include <conio.h>
#include <stdio.h>
#include <math.h>
#include "intlzr.h"

/************************************************************************/
void GetCardInfo (CRYPTOCard * Card)
/************************************************************************/
/* This function gets information into the CRYPTOCard structure pointed	*/
/* to in the parameters.  The data entered is hard coded for the sake	*/
/* of simplicity, but a Grand and Fine User Interface could be designed	*/
/* to get this data from the user.					*/
/* Dale Darling - May 8th, 1991.					*/
/************************************************************************/
{
   Set (Card->Options[0], "110");	/* These examples show some	*/
   Set (Card->Options[1], "134");	/* different techniques for	*/
   Set (Card->Options[2], "002");	/* setting the values in the	*/
   Set (Card->Keys[1][0], "111"		/* structure.			*/
			  "111"		/* This is placed in Keys[0][1] */
			  "111"		/* This in Keys[0][2], etc...	*/
			  "111"
			  "111"
			  "111111111");	/* This in Keys[0][5-7].	*/
   Set (Card->Keys[0][0], "000");
   Set (Card->Keys[0][1], "111222333144155166177");
   Set (Card->UserID[0],"111" "112" "113" "114" "115" "116" "117" "120");
   Set (Card->UserPIN, "12345678");

}
/************************************************************************/


/************************************************************************/
void PrintCardInfo (CRYPTOCard * Card)
/************************************************************************/
/* This function prints out the information in the CRYPTOCard structure	*/
/* passed in the parameters.  It can be used to double check that all	*/
/* of the proper information is stored in the structure.		*/
/* Dale Darling - May 8th, 1991.					*/
/************************************************************************/
{
  int Counter, Counter2, NumKeys;		/* Local variables.	*/

  clrscr();

  NumKeys = (int) Card->Options[2][2] - 0x30;	/* The NumKeys is set	*/
						/* by the 3rd digit of	*/
  printf ("Options:\n");			/* Option 3 ([2][2]).	*/
  printf (" %.3s %.3s %.3s\n",			/* Note how the strings	*/
		Card->Options[0],		/* are accessed. Each	*/
		Card->Options[1],		/* Option is an "oct"	*/
		Card->Options[2]);		/* which is defined as:	*/
						/* typedef char oct[3]; */
  printf ("Keys(%d):\n", NumKeys);
  for (Counter2 = 0; Counter2 < NumKeys; Counter2++) {
    for (Counter = 0; Counter < 8; Counter++)
      printf (" %.3s", Card->Keys[Counter2][Counter] );
    printf ("\n");
  }						/* The Keys are similar	*/

  printf ("UserID:\n");
  for (Counter = 0; Counter < 8; Counter++)
    printf (" %.3s", Card->UserID[Counter]);	/* As is the UserID	*/
  printf ("\n");

  printf ("PIN:\n");
  printf (" %.8s\n", Card->UserPIN);		/* The PIN however, is	*/
						/* a string of 8 digits	*/
  printf ("\nPress any key to continue...\n\n");
  getch();
}
/************************************************************************/



/************************************************************************/
void OctToASCII (char * Buffer, oct * Octal, int Length)
/************************************************************************/
/* This function converts a series of ASCII represented octal digits	*/
/* into an ASCII string.  It stores the string into Buffer.  It starts	*/
/* converting octal digits from the data area pointed to by Octal, and	*/
/* converts Length characters.						*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  for ( ; Length > 0; Length--)			/* Do Length octals 	*/
    *(Buffer++) = OctDigToASCII (*(Octal++));	/* Convert the byte	*/
  *(Buffer) = NULL;				/* NULL terminated	*/
}
/************************************************************************/



/************************************************************************/
char OctDigToASCII (oct OctalDig)
/************************************************************************/
/* This function converts a single octal digit (represented by a string	*/
/* of 3 ASCII chars - ie "107") into it's ASCII equivalent, and returns	*/
/* this value.  Note that if the Octal number is less than 3 digits	*/
/* long, 0's should be prepended to increase the length to 3.		*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  char ASCIIVal = 0;			/* The final ASCII char		*/

  ASCIIVal = ((OctalDig[0]-0x30)<<6);	/* Add first digit to ASCII	*/
  ASCIIVal |= ((OctalDig[1]-0x30)<<3);	/* Incorporate second digit	*/
  ASCIIVal |= ((OctalDig[2]-0x30));	/* And finally the third	*/

  return (ASCIIVal);			/* and send it back.  See ya.	*/
}
/************************************************************************/



/************************************************************************/
void OctToBin (char * Bin, oct * Octal, int Length)
/************************************************************************/
/* This function converts a string of Octal digits into their binary	*/
/* equivalent.  It is used to convert the Octal Key into a binary	*/
/* format to be used by the DES algorithm.				*/
/* Dale Darling - May 10th, 1991.					*/
/************************************************************************/
{
  for ( ; Length > 0; Length--, Bin ++, Octal++) {
    *(Bin) = (Octal[0][0]-0x30) * (unsigned) pow(8,2);
    *(Bin) += (Octal[0][1]-0x30) * (unsigned) pow(8,1);
    *(Bin) += (Octal[0][2]-0x30) * (unsigned) pow(8,0);
  }
}
/************************************************************************/