/************************************************************************/
/*									*/
/*	LANGUAGE.H							*/
/*									*/
/*   This file contains the LanguageTable used by the InitCard()	*/
/* function.  It contains all of the languages supported by the 	*/
/* CRYPTOCard.  The words in the table are identical to those displayed	*/
/* by the CRYPTOCard during manual initialization, and are used to	*/
/* verify that the initialization process is proceding as planned.	*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/

char LanguageTable [NO_LNG][10][9] = {

/* English 1 */
            "Key1?   ",
            "Key2?   ",
            "Key3?   ",
            "User ID?",
            "New PIN?",
            "Verify  ",
            "Card OK ",
            "PIN?    ",
            "Locked  ",
            "Options?",

/* English 2 */
            "Key1?   ",                 /*Key1?   */
            "Key2?   ",                 /*Key2?   */
            "Key3?   ",                 /*Key3?   */
            "User ID?",                 /*User ID?*/
            "New PSC?",                 /*New PIN?*/
            "Verify  ",                 /*Verify  */
            "Card OK ",                 /*Card OK */
            "PSC?    ",                 /*PIN?    */
            "Locked  ",                 /*Locked  */
            "Options?",                 /*Options?*/

/* French */
            "Clef1?  ",                 /*Key1?   */
            "Clef2?  ",                 /*Key2?   */
            "Clef3?  ",                 /*Key3?   */
	    "Usag?  ",                 /*User ID?*/
            "Nouveau?",                 /*New PIN?*/
            "Verifier",                 /*Verify  */
            "Correct ",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Bloqu  ",                 /*Locked  */
            "Options?",                 /*Options?*/

/* German */
            "Chiffre1",                 /*Key1?   */
            "Chiffre2",                 /*Key2?   */
            "Chiffre3",                 /*Key3?   */
            "Ident. #",                 /*User ID?*/
            "Neue PIN",                 /*New PIN?*/
            "Beweise ",                 /*Verify  */
            "Karte OK",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Gesperrt",                 /*Locked  */
            "Auswahl?",                 /*Options?*/

/* Italian */
            "Chiave1?",                 /*Key1?   */
            "Chiave2?",                 /*Key2?   */
            "Chiave3?",                 /*Key3?   */
            "ID Usare",                 /*User ID?*/
            "Nuovo?  ",                 /*New PIN?*/
            "Verifica",                 /*Verify  */
            "Carta OK",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Chiuso  ",                 /*Locked  */
            "Scelta? ",                 /*Options?*/

/* Portuguese */
            "Codig1?",                 /*Key1?   */
            "Codig2?",                 /*Key2?   */
            "Codig3?",                 /*Key3?   */
            "Nr.Conta",                 /*User ID?*/
            "Nvo PIN",                 /*New PIN?*/
            "Repetir ",                 /*Verify  */
            "Correcto",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Nulo    ",                 /*Locked  */
            "Opes? ",                 /*Options?*/

/* Swedish */
            "Tangent1",                 /*Key1?   */
            "Tangent2",                 /*Key2?   */
            "Tangent3",                 /*Key3?   */
            "Kund-ID?",                 /*User ID?*/
            "Ny PIN? ",                 /*New PIN?*/
            "Bekrfta",                 /*Verify  */
            "Kort OK ",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Sprrad ",                 /*Locked  */
            "Val?    ",                 /*Options?*/

/* Spanish */
            "Clave1? ",                 /*Key1?   */
            "Clave2? ",                 /*Key2?   */
            "Clave3? ",                 /*Key3?   */
            "Ident. #",                 /*User ID?*/
            "Nuevo?  ",                 /*New PIN?*/
            "Asegurar",                 /*Verify  */
            "Correcto",                 /*Card OK */
            "PIN?    ",                 /*PIN?    */
            "Atascado",                 /*Locked  */
            "Opciones"                  /*Options?*/
};
