/************************************************************************/
/*									*/
/*	INTLZR.H							*/
/*									*/
/*   This file contains global definitions and function prototypes for	*/
/* the Initializer program.						*/
/*									*/
/*   These functions were written using TurboC v2.0, (c) 1988,		*/
/* Borland International.						*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/


/************************************************************************/
/* Commonly used header files :						*/
/************************************************************************/


/************************************************************************/
/* Global Definitions:							*/
/************************************************************************/
#define COM1	0x3F8       /* Serial I/O address bsae for port 1	*/
#define COM2	0x2F8       /* Address base for Com. port 2		*/
#define RBR 0               /* Receiver Buffer Register's Offset	*/
#define THR 0               /* Transmitter Holding Register's Offset	*/
#define IER 1               /* Interrupt Enable Register's Offset	*/
#define IIR 2               /* Interrupt Identification Register's Off. */
#define LCR 3               /* Line Control Register's Offset		*/
#define MCR 4               /* Modem Control Register's Offset		*/
#define LSR 5               /* Line Status Register's Offset		*/
#define MSR 6               /* Modem Status Register's Offset		*/
#define DLL 0               /* Divisor Latch's Offset - lsb		*/
#define DLM 1               /* Divisor Latch's Offset - msb		*/

#define THRE	0x20	    /* Transmit Holding Register Empty bit	*/
#define TE	0x40	    /* Transmit Empty bit of THR		*/
#define RDR	0x01	    /* Receive Data Ready bit (of THR)		*/

#define DTR	0x01	    /* Data Transfer Ready (MCR)		*/
#define RTS	0x02	    /* Request To Send (Modem Control Register)	*/
/*
#define	DEBUG               /* Debug mode - currently not activated	*/
#define NO_FXTR             /* Indicate no initializer - for testing	*/
*/


#define VER32		    /* CRYPTOCard is version 3.2 or greater -
				used to determine which language table
				to search within.			*/


#define ERROR   0           /* The following are general defines used	*/
#define FALSE   0           /* to make the code more readable		*/
#define TRUE    1
#define NOERROR 1

#define NO_LNG  8           /* Number of languages supported		*/
#define PAUSE   9           /* Delay time for messages in 1/18 seconds	*/
#define TM_OUT_MAX  3       /* Maximum time out in seconds		*/

#define LED_NONE	0x00	/* No LEDs on (Initializer front panel)	*/
#define LED_RESET	0x01	/* Reset LED on				*/
#define LED_INSERT	0x02	/* Insert LED on			*/
#define LED_INIT	0x04	/* Init LED on				*/
#define LED_DONE	0x08	/* Done LED on				*/
#define LED_ERROR	0x10	/* Error LED on				*/
#define SOL		0x60	/* Solenoid & flash on			*/

#define SCROLL_KEY	0x0B	/* The code for the SCROLL key		*/
#define ENT_KEY		0x0C	/* The code for ENT key on CRYPTOCard	*/

/* The following defines show which position (in each respective	*/
/* language) the messages are in the LanguageTable defined in the file	*/
/* "LANGUAGE.H".							*/
#define KEY1		0x00
#define KEY2		0x01
#define KEY3		0x02
#define USER_ID		0x03
#define NEW_PIN		0x04
#define VERIFY		0x05
#define CARD_OK		0x06
#define PIN		0x07
#define LOCKED		0x08
#define OPTIONS		0x09

/* The following defines identify the results from the call to the 	*/
/* function InitializeCard(). 						*/
#define CRYPT_NO_RSPNS		-1	/* No response from the Card	*/
#define CRYPT_COM_ERR		-2	/* Communication error		*/
#define CRYPT_NO_OPTS		-3	/* "Options?" message not found	*/
#define CRYPT_NO_KEYX		-4	/* "Keyx?" message not found	*/
#define CRYPT_BAD_ENCRPT	-5	/* Encryption from card doesn't
					   match the computers version	*/
#define CRYPT_NO_ID		-6	/* "User ID?" message not found	*/
#define CRYPT_BAD_ID		-7	/* Displayed ID doesn't match
					   the computer's version	*/
#define CRYPT_NO_NEWPIN		-8	/* "New PIN?" message not found	*/
#define CRYPT_NO_VER		-9	/* "Verify" message not found	*/
#define CRYPT_NO_OK		-10	/* "Card OK" message not found	*/
#define CRYPT_NO_PIN		-11	/* "PIN?" message not found	*/


/************************************************************************/
/* Variable typedefs and structure definitions:				*/
/************************************************************************/
typedef unsigned char byte;	/* Definition of the byte		*/
typedef char oct[3];		/* String of chars representing an	*/
				/* octal byte (ie "163")		*/
typedef char hex[2];		/* String of chars representing a hex	*/
				/* byte (ie "4E") (No null termiator)	*/
typedef char dec;		/* String to represent a single decimal	*/
				/* digit (ie "1" or "8")		*/
typedef struct {		/* Structure contains CRYPTOCard info	*/
   oct	Options[3];		/* Octal digits for all the "Options?"	*/
   oct	Keys[3][8];		/* Octal digits for all of the "Keys"	*/
   oct	UserID[8];		/* Octal digits of the User ID		*/
   dec	UserPIN[8];		/* Decimal format of User's PIN (0-9)	*/
} CRYPTOCard;			/* Aptly named structure		*/

/* NOTES:  The above structure may seem to be oddly designed.  This	*/
/*  implementation is not the most efficient, but it allows for easy	*/
/*  definitions of cards, as one merely has to enter a string that	*/
/*  looks identical to one typed onto the CRYPTOCard's keypad into the	*/
/*  various fields of the structure.  ie, entering the first number of	*/
/*  Key1 would be as simple as this:					*/
/*	Set (MyCard.Key[0][0], "174");					*/
/*  where MyCard is declared to be of type CRYPTOCard.  "174" are the	*/
/*  digits that the user would type on the CRYPTOCard's keypad when it	*/
/*  requested "Key1?" and then digit "1".  The Set() Macro is defined	*/
/*  below, and it merely copies the contents of the string constant	*/
/*  into the char variable. This ASCII string is the format that the	*/
/*  Initializer expects the data (ie sending byte 0x00 is the same as	*/
/*  digit 0 on the keypad).						*/


/************************************************************************/
/* Macro definitions:							*/
/************************************************************************/
/* The following macro can be used to set the value of an array of	*/
/* chars to a string constant.  Due to the design of the structure, the	*/
/* values cannot be set in a manner such as this:			*/
/*	Card->Options[0] = "110";					*/
/* This causes an Lvalue required error.  The following method causes	*/
/* a Non-portable pointer assignement warning:				*/
/*	*(Card->Options[0]) = "110";					*/
/*		or							*/
/*	Card->Options[0][0] = "110";					*/
/* These methods, although they may generate code that compiles and	*/
/* executes correctly, should be avoided for portability purposes.	*/
/*   Note that strcpy() could also be used, but this would append a	*/
/* NULL to the end of the string, and no space is allocated for NULL	*/
/* terminators, nor do the Initializer functions expect any.  So great	*/
/* care would have to be taken to ensure that data was not overwritten.	*/

#define Set(Dest,Src) {char *Temp1=Src,Temp2=0;\
			while(*Temp1) Dest[Temp2++]=*(Temp1++);}


/************************************************************************/
/* Function Prototypes:							*/
/************************************************************************/
/* Each of these functions are described in detail within their		*/
/* respective function definitions.  The comments to the right of each	*/
/* show which module they are defined in.				*/
/************************************************************************/
void	GetCardInfo (CRYPTOCard * Card);		/* "MISC.C"	*/
void	PrintCardInfo (CRYPTOCard * Card);		/* "MISC.C"	*/
void	OctToASCII (char * Buffer, oct * Octal, int Length);
							/* "MISC.C"	*/
char	OctDigToASCII (oct OctalDig);			/* "MISC.C"	*/
void	OctToBin (char *Bin, oct * Octal, int Length);	/* "MISC.C"	*/

int	InitializeCard (CRYPTOCard * Card);		/* "INITFNS.C"	*/

void	SetPort (int Port);				/* "INITFNS.C"	*/
int	LinkWithCard (void);				/* "INITFNS.C"	*/
int	SendOptions (CRYPTOCard * Card);		/* "INITFNS.C"	*/
int	SendKeys (CRYPTOCard * Card);			/* "INITFNS.C"	*/
int	SendUserID (CRYPTOCard * Card);			/* "INITFNS.C"	*/
int	SendPIN (CRYPTOCard * Card);			/* "INITFNS.C"	*/
void	GetEncryptedResult (oct * Key, char * Encrypt);	/* "INITFNS.C"	*/

int	IsCardIn (void);				/* "CARDFNS.C"	*/
int	SendByteToCard (byte Byte);			/* "CARDFNS.C"	*/
int	GetBufFromCard (char * BufPtr, int Length);	/* "CARDFNS.C"	*/
int	SendOctal (oct Octal);				/* "CARDFNS.C"	*/
int	GotThisBuf (char *Buffer);			/* "CARDFNS.C"	*/
int	SendDec (char * Decimal, int Length);		/* "CARDFNS.C"	*/

int	GetByteFromFixture (void);			/* "FIXFNS.C"	*/
int	SendByteToFixture (byte Byte);			/* "FIXFNS.C"	*/

int	SendByte (byte Byte, int Port);			/* "PORTFNS.C"	*/
int	GetByte (int Port);				/* "PORTFNS.C"	*/
void	InitPort (int Port);				/* "PORTFNS.C"	*/
int	WaitOnSentByte (int Port);			/* "PORTFNS.C"	*/
int	WaitForByte (int Port);				/* "PORTFNS.C"	*/
void	ClearPort (int Port);				/* "PORTFNS.C"	*/

void	DES (char *Dest, char *Source, char *Key, unsigned Function);
							/* "DES.ASM"	*/
/* Note that the file "DESx.OBJ" must be included in the project file,	*/
/* where "x" represents the memory model (in this case, "S" for small).	*/
/* "x" can be "L"arge, "C"ompact, "M"edium, or "S"mall.			*/
