/************************************************************************/
/*									*/
/*	INTLZR.C	"Initializer C code"				*/
/*									*/
/*   This file contains the mainline function for the Initializer	*/
/* program.  The functions are found in other C modules in this 	*/
/* directory.  Their object code is linked in INTLZR.PRJ, and so the	*/
/* project file in TurboC's environment should be set to this file.	*/
/*   INTLZR.H contains the function prototypes as well as various	*/
/* definitions useful for this application.				*/
/*   As it stands, this program simply sets up a structure that holds	*/
/* a hard-coded initialization sequence for a CRYPTOCard.  The infor-	*/
/* mation is defined in the file "MISC.C", in function GetCardInfo().	*/
/* The structure contains strings of ASCII characters that represent	*/
/* the actual keystrokes that a user would hit on the CRYPTOCard's 	*/
/* keypad when prompted for the specific information.  Note that these	*/
/* strings are not NULL terminated.  As such, the structure is simply	*/
/* a continuous block of ASCII characters.  Note also that any special	*/
/* keys that are pressed on the keypad (such as the SCROLL key or the	*/
/* ENT key) are inserted by the functions that actually send the data,	*/
/* and should not be included in the structure.  Examination of the 	*/
/* header file as well as the GetCardInfo() function will make this	*/
/* more clear.								*/
/*   Once the structure is set up, it is simply a matter of calling the	*/
/* function InitializeCard() to do just that.  All of the functions	*/
/* used by InitializeCard() are included in separate modules in order	*/
/* that you may decipher more concerning the communication protocol	*/
/* between the PC and the Initializer.					*/
/*   Feel free to modify any of these functions to suit your needs.	*/
/* Dale Darling - May 8th, 1991.					*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/

/************************************************************************/
/* The necessary header files are included below:			*/
/************************************************************************/
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include "intlzr.h"

/************************************************************************/
void main (void)
/************************************************************************/
/* The mainline program follows:					*/
/************************************************************************/
{
  int Error;
  CRYPTOCard Card;			/* Define a variable to contain	*/
					/* the card data		*/
  GetCardInfo (&Card);			/* Set the card information	*/
  PrintCardInfo (&Card);		/* Show it for testing		*/

  SetPort (COM1);			/* Tell Initialize functions	*/
					/* which port to use.		*/
  while (1) {
  if ( (Error = InitializeCard (&Card)) == 0)	/* Do the init. and 	*/
    printf ("CRYPTOCard initialized successfully.\n");	/* check for	*/
  else {				/* success.  Tell the user.	*/
    printf ("CRYPTOcard was not initialized.\n");
    printf ("Error return code: %d.\n", Error);
  }
  printf ("Press any key...\n");
  getch();
  }
					/* Could decipher the error	*/
					/* but for now, we don't bother	*/
}					/* End of main().		*/
/************************************************************************/