/************************************************************************/
/*									*/
/*	FIXFNS.C	"Fixture Functions"				*/
/*									*/
/*  This file contains some intermediate functions used to send and	*/
/* receive bytes to and from the Initializer.				*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/


/************************************************************************/
/* Header files:							*/
/************************************************************************/
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include "intlzr.h"


/************************************************************************/
/* External variables:							*/
/************************************************************************/
extern int _Port;


/************************************************************************/
int GetByteFromFixture (void)
/************************************************************************/
/* This function tries to grab a byte from the port currently being	*/
/* used for communication with the Initializer.  The external variable	*/
/* "_Port" defines this port address.  It is defined in "INITFNS.C".	*/
/* Note that if NO_FXTR is defined, then the function merely returns	*/
/* a TRUE (1).  To use the program without an Initializer, remove the	*/
/* comments from around "#define NO_FXTR" in "INTLZR.H".		*/
/* On success it returns the byte read, on failure it returns -1.	*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
#if defined (NO_FXTR)
  return (TRUE);
#else
  return (GetByte (_Port));
#endif
}
/************************************************************************/



/************************************************************************/
int SendByteToFixture (byte Byte)
/************************************************************************/
/* This function attempts to send the byte passed in the parameters out	*/
/* the port currently being used for communication with the Initial-	*/
/* izer.  If the byte would not leave the port, this function keeps	*/
/* trying for ever and anon, or until the user strikes any key (which	*/
/* is promptly ignored).  If the user has interrupted, this function	*/
/* returns a FALSE; a TRUE indicates that all went rather well.		*/
/* If NO_FXTR is defined, it checks if the LED_INSERT bit is set high	*/
/* (of the Byte to send); if so, it returns TRUE, otherwise it returns	*/
/* FALSE.								*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
#if defined (NO_FXTR)
  if (Byte & LED_INSERT)
    return (TRUE);
  return (FALSE);
#else
  int Status = FALSE;				/* Init Status var	*/

  outportb (_Port+MCR, (DTR|RTS));		/* Set DTR and RTS high	*/
/*  printf ("Waiting for Card Fixture to return status.\n"); */
  do {
    ClearPort (_Port);				/* Clear bytes from RBR	*/
    SendByte (Byte, _Port);			/* Send the Byte	*/
    if (kbhit ()) {				/* If user interrupts	*/
      getch();					/* Throw out the key	*/
      return (FALSE);				/* Indicate an error	*/
    }
  } while ((Status = GetByte (_Port)) == -1);	/* Wait for response	*/
  outportb (_Port+MCR, DTR);			/* Reset RTS to low	*/
  return (Status);				/* Return TRUE		*/
#endif
}
/************************************************************************/
