/************************************************************************/
/*									*/
/*	CARDFNS.C	"Card Functions"				*/
/*									*/
/*   This file contains functions that write and read information to	*/
/* and from the CRYPTOCard in the Card Fixture.  It also has a function	*/
/* that indicates whether a card is in the Initializer or not.		*/
/*									*/
/*   (C) - 1991 CRYPTOCard Corporation.  All rights reserved.		*/
/*									*/
/************************************************************************/

/************************************************************************/
/* Header files:							*/
/************************************************************************/
#include <alloc.h>
#include "intlzr.h"

/************************************************************************/
/* External variables:							*/
/************************************************************************/
extern int _Port;


/************************************************************************/
int IsCardIn (void)
/************************************************************************/
/* This function determines whether a CRYPTOCard is inserted into the	*/
/* Initializer, and returns TRUE (1) if so.  Otherwise it returns FALSE	*/
/* (0).	 It communicates through the port specified in the global	*/
/* variable _Port, which can be defined using the function SetPort().	*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  if (SendByteToFixture (LED_INSERT) & 0x01)	/* This return code	*/
    return (TRUE);				/* shows it's there	*/
  else						/* Otherwise,		*/
    return (FALSE);				/* It ain't!		*/
}
/************************************************************************/


/************************************************************************/
int SendByteToCard (byte Byte)
/************************************************************************/
/* This function sends a byte out the serial port indicated in the	*/
/* external variable _Port, to be sent as a keystroke through to the 	*/
/* CRYPTOCard inserted in the Initializer.  If there was a timeout in	*/
/* waiting for the THR to Empy, then this function returns FALSE (0).	*/
/* If all went well, it returns TRUE (1).				*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
#if defined (NO_FXTR)
  return (TRUE);			/* Pretend that it worked.	*/
#else
  if (SendByte (Byte, _Port) == Byte)	/* Check that it worked.	*/
    return (TRUE);
  return (FALSE);
#endif
}
/************************************************************************/


/************************************************************************/
int GetBufFromCard (char * BufPtr, int Length)
/************************************************************************/
/* This function gets a string of ASCII characters from the card into	*/
/* the buffer pointed to by the parameter.  If communication is exec-	*/
/* uting correctly, the string of characters should be identical to	*/
/* what would be displayed on the CRYPTOCard's screen at this stage of	*/
/* the card's initialization.  If there is a communication error, FALSE	*/
/* (0) is returned.  Otherwise TRUE (1) is returned.  It reads Length	*/
/* characters from the port.  If it cannot get that many, it returns	*/
/* FALSE.  Otherwise it returns TRUE and ignores any excess data (but 	*/
/* does not flush the port clean).					*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  int Byte;					/* The actual data read	*/
  for ( ; Length > 0; Length--, BufPtr++) {	/* Read Length bytes	*/
    Byte = GetByte (_Port);			/* Grab a byte		*/
    if (Byte != -1)				/* If it got a byte	*/
      *(BufPtr) = Byte;				/* Put it in the buffer	*/
    else					/* Otherwise: timeout 	*/
      return (FALSE);				/* Can't touch that	*/
  }						/* End the loop		*/
  return (TRUE);				/* It got all the bytes	*/
}
/************************************************************************/



/************************************************************************/
int SendOctal (oct Octal)
/************************************************************************/
/* This function sends the octal digits passed in the parameter out to	*/
/* the CRYPTOCard, appending the SCROLL_KEY to the end.  The octal 	*/
/* digits are in ASCII format (ie "134" for 134).  If they were sent	*/
/* successfully, this function returns TRUE, otherwise it returns	*/
/* FALSE.								*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  int Counter=0;				/* Loop counter		*/
  for ( ; Counter<3; Counter++) {		/* 3 digits in octal 	*/
    if (!(SendByteToCard (Octal[Counter] - 0x30)))  /* Send and check	*/
      return (FALSE);				/* if it went well	*/
    GetByte (_Port);				/* Get byte number and	*/
  }						/* ignore it		*/
  if (!(SendByteToCard (SCROLL_KEY)))		/* Send the scroll key	*/
    return (FALSE);
  GetByte (_Port);
  return (TRUE);
}
/************************************************************************/



/************************************************************************/
int SendDec (char * Decimal, int Length)
/************************************************************************/
/* This function sends the string of decimal numbers pointed to in the	*/
/* parameter across to the CRYPTOCard.  If there was no communication	*/
/* error, it returns TRUE, otherwise: FALSE.  The string is in ASCII	*/
/* format. Ie "13312459".  It is used for sending PIN's and the back-	*/
/* door reset sequence.  It sends out Length bytes from the string.	*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  for ( ; Length > 0; Length--)			/* Go until Length = 0	*/
    if (!(SendByteToCard (*(Decimal++)-0x30)))	/* Send it and check	*/
      return (FALSE);				/* If error-tell caller	*/
  return (TRUE);				/* All were nicely sent	*/
}
/************************************************************************/



/************************************************************************/
int GotThisBuf (char * Buffer)
/************************************************************************/
/* This function reads a buffer from the CRYPTOCard and compares it to	*/
/* the buffer pointed to in the parameter.  If they are equal, it	*/
/* returns TRUE, otherwise it returns FALSE.				*/
/* Dale Darling - May 9th, 1991.					*/
/************************************************************************/
{
  char * CardBuffer, * BackUp;		/* Some overly-large buffer	*/
  int Equal = TRUE;			/* Optimistic default return	*/
  int Length = 0;			/* The length of the buffer	*/

  BackUp = Buffer;			/* Save a copy of the pointer	*/

  while (*(Buffer)++)			/* Calculate the length of the	*/
    Length ++;				/* NULL terminated buffer	*/

  Buffer = BackUp;			/* Restore the pointer		*/

  BackUp = CardBuffer = (char *) malloc (Length+1);	/* Grab a bufr	*/

  if (!(GetBufFromCard (CardBuffer, Length)))	/* Get the Buffer	*/
    Equal = FALSE;			/* Communication error		*/
  while (*Buffer)			/* Go until we hit a NULL	*/
    if (*(CardBuffer++) != *(Buffer++))	/* If there is a discrepancy	*/
      Equal = FALSE;			/* indicate this to caller	*/
  free (BackUp);			/* Free up those 41 bytes	*/
  return (Equal);			/* Return the calculated value	*/
}
/************************************************************************/
