unit Indxmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Tuidx, DB, DBTables;

type
  TFormIndxProjMain = class(TForm)
    IdxUtl1: TIdxUtl;
    OpenDialog1: TOpenDialog;
    ButtonBrowse: TButton;
    EditFileName: TEdit;
    ListBoxStatus: TListBox;
    ButtonCheckIndexes: TButton;
    ButtonRegenIndexes: TButton;
    procedure ButtonBrowseClick(Sender: TObject);
    procedure EditFileNameExit(Sender: TObject);
    procedure ButtonCheckIndexesClick(Sender: TObject);
    procedure IdxUtl1InfoIdxCheck(Sender: TObject; IndexName: String;
      IsUptoDate: Boolean);
    procedure ButtonRegenIndexesClick(Sender: TObject);
    procedure IdxUtl1InfoIdxRegen(Sender: TObject; IndexName: String;
      IsUptoDate: Boolean; var Skip: Boolean);
  private
    { Private declarations }
    Procedure SendToLog(aMsg : String);
  public
    { Public declarations }
  end;

var
  FormIndxProjMain: TFormIndxProjMain;

implementation

{$R *.DFM}

Procedure TFormIndxProjMain.SendToLog(aMsg : String);
begin
  With ListBoxStatus do
  begin
    Items.Add(AMsg);
    { This next bit scrolls the text so the most recent msg is visible}
    if (ItemHeight * Items.count) > Height then
      TopIndex:= Items.count - (Height div ItemHeight) ;
  end;
  ListBoxStatus.Refresh;
end;

procedure TFormIndxProjMain.ButtonBrowseClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    { Set the TableName Name property for the TIdxUtl to be checked }
    IdxUtl1.TableName := OpenDialog1.FileName;
    EditFileName.Text := IdxUtl1.TableName;
  end;
end;

procedure TFormIndxProjMain.EditFileNameExit(Sender: TObject);
begin
 if EditFileName.Text = '' then exit;
 { Set the TableName Name property for the TUtility to be checked for corruption }
 IdxUtl1.TableName := ExpandFileName(EditFileName.Text);
end;

procedure TFormIndxProjMain.ButtonCheckIndexesClick(Sender: TObject);
begin
  if not IdxUtl1.CheckIndexes then
    MessageDlg('Index(es) are out of date and should be regenerated.',
                 mtWarning, [mbOk], 0);
end;

procedure TFormIndxProjMain.IdxUtl1InfoIdxCheck(Sender: TObject;
  IndexName: String; IsUptoDate: Boolean);
begin
  if IsUptoDate then
    SendToLog('Index ' + IndexName + ' is up to date.')
  else
    SendToLog('INDEX ' + Uppercase(IndexName) + ' IS OUT OF DATE.');
end;

procedure TFormIndxProjMain.ButtonRegenIndexesClick(Sender: TObject);
begin
  IdxUtl1.RegenIndex;
end;

procedure TFormIndxProjMain.IdxUtl1InfoIdxRegen(Sender: TObject;
  IndexName: String; IsUptoDate: Boolean; var Skip: Boolean);
begin
  if IsUptoDate then
  begin
    if MessageDlg(IndexName + ' is not out of date do you want to regenerate it anyway?',
                 mtInformation, [mbYes,mbNo], 0) = mrYes then
    begin
      Skip := False;
      SendToLog(IndexName + ' is being regenerated.');
    end
    else
    begin
      Skip := True;  {this line is not necessary cause Skip is true by default}
      SendToLog(IndexName + ' not out of date and not being regenerated.');
    end;
  end
  else
  begin
    Skip := False; {this line is not necessary cause Skip is false by default}
    SendToLog(IndexName + ' is being regenerated.');
  end;
end;

end.
