unit Getdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, BatchDlg, Dialogs, DBTables, DB;

type
  TGetBatchDlg = class(TForm)
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    ButtonSelectBatch: TButton;
    ButtonNewBatch: TButton;
    OpenDialogSelectBatch: TOpenDialog;
    SaveDialogNewBatch: TSaveDialog;
    ButtonEdit: TButton;
    procedure ButtonSelectBatchClick(Sender: TObject);
    procedure ButtonNewBatchClick(Sender: TObject);
    procedure ButtonEditClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GetBatchDlg: TGetBatchDlg;

implementation

{$R *.DFM}

procedure TGetBatchDlg.ButtonSelectBatchClick(Sender: TObject);
begin
  if OpenDialogSelectBatch.Execute then
  begin
    FormBatchDef.TableBatch.Active := False;
    FormBatchDef.TableBatch.DatabaseName :=
      ExtractFilePath(OpenDialogSelectBatch.FileName);
    FormBatchDef.TableBatch.TableName :=
      ExtractFileName(OpenDialogSelectBatch.FileName);
    modalResult := idYes;
  end
  else
    modalResult := idCancel;
end;

procedure TGetBatchDlg.ButtonNewBatchClick(Sender: TObject);
begin
  If SaveDialogNewBatch.Execute then
  begin
    with FormBatchDef.TableBatch do
    begin
      Active := False;
      DatabaseName := ExtractFilePath(SaveDialogNewBatch.FileName);
      TableName := ExtractFileName(SaveDialogNewBatch.FileName);
      TableType := ttParadox;
      Try
        with FieldDefs do
        begin
          Clear;
          Add('TableName',     ftString, 79, False);
          Add('BackUpName',    ftString, 79, False);
          Add('AltStructName', ftString, 79, False);
          Add('KeyVTableName', ftString, 79, False);
          Add('ProbTableName', ftString, 79, False);
        end;
        with IndexDefs do
        begin
          Clear;
          Add('', 'TableName', [ixPrimary, ixUnique]);
        end;
        CreateTable;
        modalResult := idOK;
      except
        modalResult := idCancel;
        raise;
      end;
    end;
  end
  else
    ModalResult := idCancel;
end;

procedure TGetBatchDlg.ButtonEditClick(Sender: TObject);
begin
  if OpenDialogSelectBatch.Execute then
  begin
    FormBatchDef.TableBatch.Active := False;
    FormBatchDef.TableBatch.DatabaseName :=
      ExtractFilePath(OpenDialogSelectBatch.FileName);
    FormBatchDef.TableBatch.TableName :=
      ExtractFileName(OpenDialogSelectBatch.FileName);
    modalResult := idOK;
  end
  else
    modalResult := idCancel;
end;

end.
