unit Clntserv;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, About, Sockets, ExtCtrls;

type
  TForm1 = class(TForm)
    Connect: TButton;
    SendData: TButton;
    Listen: TButton;
    Close: TButton;
    CancelListen: TButton;
    Port: TEdit;
    Label2: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    Label5: TLabel;
    HelpButton: TButton;
    Label1: TLabel;
    IPAddr: TEdit;
    Sockets1: TSockets;
    SocketTypeGroup: TRadioGroup;
    procedure ConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SendDataClick(Sender: TObject);
    procedure ListenClick(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure CancelListenClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure Sockets1SessionConnected(Sender: TObject; Socket: Word);
    procedure Sockets1SessionAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1DataAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1SessionClosed(Sender: TObject; Socket: Word);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  clientserver: integer;
  clientadd: u_long;
  clientport: u_short;

implementation

{$R *.DFM}

procedure TForm1.ConnectClick(Sender: TObject);
var
  szMsg: array[0..255] of char;
  SocketType: integer;

begin
  Listen.Enabled := False;
  Sockets1.IPAddr := IPAddr.Text;
  Sockets1.Port := Port.Text;
  Sockets1.Protocol := IPPROTO_IP;
  case SocketTypeGroup.ItemIndex of
   0: SocketType := SOCK_DGRAM;
   1: SocketType := SOCK_STREAM;
  end;{case}
  Sockets1.SocketType := SocketType;
  Sockets1.SConnect;
  {Remember that UDP clients do not actually establish a connection.  UDP
   is a connectionless protocol.  The only purpose that the connect method
   serves is to set the host address and port, so that they do not need to
   be stated in susequent calls to send and receive.}
  clientserver := 1;

  Connect.Enabled := False;
  Connect.Enabled := False;
  SendData.Enabled := True;
  Listen.Enabled := False;
  Close.Enabled := True;
  CancelListen.Enabled := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Port.Text := '1645';{Sockets1.Port;}
IPAddr.Text := {'160.0.1.4'}Sockets1.IPAddr;
Connect.Enabled := True;
SendData.Enabled := False;
Listen.Enabled := True;
Close.Enabled := False;
CancelListen.Enabled := False;
clientserver := 0;
clientadd := 0;
clientport := 0;
end;

procedure TForm1.SendDataClick(Sender: TObject);
var sendBuf: PByte;
    delStr: string;
    sendlen, sentlen: integer;
begin
  delStr := Edit1.Text;
  delStr := delStr + #0;
  sendBuf := @delStr[1];
  sendlen := length(delStr);
  sentlen := Sockets1.SSend(Sockets1.SocketNumber, Pointer(sendBuf), sendlen,
             clientadd, clientport);

end;

procedure TForm1.ListenClick(Sender: TObject);
begin
  Edit1.Text := '';
  Edit1.Enabled := False;
  Connect.Enabled := False;
  SendData.Enabled := False;
  Sockets1.Port := Port.Text;
  Sockets1.Protocol := IPPROTO_IP;
   case SocketTypeGroup.ItemIndex of
   0: Sockets1.SocketType := SOCK_DGRAM;
   1: Sockets1.SocketType := SOCK_STREAM;
  end;{case}

  Sockets1.SListen;
  Listen.Enabled := False;
  Close.Enabled := False;
  CancelListen.Enabled := True;
  clientserver := 2;
  Memo1.Lines.Add('Listening on socket('+IntToStr(Sockets1.MasterSocket)+')');
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
  Sockets1.SClose;
  if clientserver <> 2 then {not server?}
  begin
    Connect.Enabled := True;
    SendData.Enabled := False;
    Listen.Enabled := True;
    Close.Enabled := False;
    CancelListen.Enabled := False;
    clientserver := 0;
  end;
end;

procedure TForm1.CancelListenClick(Sender: TObject);
begin
  If Sockets1.SocketType = SOCK_STREAM then begin
  {there is only one active socket for UDP Server, so we only
   close down that one.}
     If Sockets1.SocketNumber <> INVALID_SOCKET Then
        Sockets1.SClose;
  end;
  If Sockets1.MasterSocket <> INVALID_SOCKET Then
    Sockets1.SCancelListen;
  Connect.Enabled := True;
  SendData.Enabled := False;
  Listen.Enabled := True;
  Close.Enabled := False;
  CancelListen.Enabled := False;
end;

procedure TForm1.HelpButtonClick(Sender: TObject);
begin
  AboutBox.Show;
end;

procedure TForm1.Sockets1SessionConnected(Sender: TObject; Socket: Word);
begin
{ONLY FOR SOCK_STREAM type sockets, not UDP}
  Connect.Enabled := False;
  SendData.Enabled := True;
  Listen.Enabled := False;
  Close.Enabled := True;
  CancelListen.Enabled := False;
end;

procedure TForm1.Sockets1SessionAvailable(Sender: TObject; Socket: Word);
var
  new_client: TSocket;
begin
{this only gets called when the server is of type SOCK_STREAM}
  new_client := Sockets1.SAccept;
  Memo1.Lines.Add('Client session accepted, socket(' + IntToStr(new_client) + ')');
  Listen.Enabled := False;
  CancelListen.Enabled := True;
end;

procedure TForm1.Sockets1DataAvailable(Sender: TObject; Socket: Word);
var
  Buf: string;
  pBuf: PByte;
  recvlen, sentlen: integer;

begin
  Sockets1.SocketNumber := Socket;

  GetMem(pBuf,1024);{Get some memory to store the received data}
  sentlen := 1024;
  recvlen := Sockets1.SReceive(Sockets1.SocketNumber, Pointer(pBuf), sentlen, clientadd, clientport);
  if recvlen = 0 then
     exit;
  Memo1.Lines.Add('Data recevied from socket(' + IntToStr(Socket) + ')');
  {Here we are only interested in Sending and receiving strings, so we will
  cast the pointer to a byte to a PChar so that we can manipulate the received
  buffer as a string.  To see how to increment through the buffer as a PByte see
  the online help.}
  Buf := strpas(PChar(pBuf));
  Memo1.Lines.Add('-->' + buf + '<--');
  If clientserver = 2 Then{Server}
  begin
    sentlen := Sockets1.SSend(Sockets1.SocketNumber, Pointer(pBuf), recvlen,
             clientadd, clientport);
    Memo1.Lines.Add('...Buffer echoed back to client');
  end;
  FreeMem(pBuf, 1024);{Free the memory}
end;

procedure TForm1.Sockets1SessionClosed(Sender: TObject; Socket: Word);
begin
  Memo1.Lines.Add('Lost connection on socket(' + IntToStr(Socket) + ')');
  Sockets1.SocketNumber := Socket;
  CloseClick(Self);
end;

end.

