unit navfrm;
{------------------------------------------------------------------------------
 OENavigator, OEExtHstmt, OETables, OEDatasources Demo Program.

 All component provided by CRYPTOCard Corporation.

 ODBC Express Add On components.

 Contact Greg Carter, CRYPTOCard Corporation, gregc@cryptocard.com
 Latest updates can be found at http://www.cryptocard.com/oeext.html
 other Delphi components at http://www.cryptocard.com/pascal.html

 comments, suggestions welcome!

 This demo requires that you have installed the MS ODBC driver pack 3.0, and
 have setup an Access Datasource called TESTACCESS32, and have run the TESTSQL
 demo from ODBC Express, which fills some tables with data(students, takes,
 courses).
-------------------------------------------------------------------------------}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  oddscb,oenav, OCIH, OCI, ODI, ExtCtrls, StdCtrls, Grids, ExtGrid, ComCtrls, OCL;

type
  TForm1 = class(TForm)
    Henv1: THenv;
    Hdbc1: THdbc;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    OEEdit1: TOEEdit;
    OEEdit2: TOEEdit;
    OEGrid1: TOEGrid;
    Label1: TLabel;
    Label2: TLabel;
    OEDBNavigator1: TOEDBNavigator;
    BrowseExtHstmt: TOEExtHstmt;
    InsertExtHstmt: TOEExtHstmt;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    ODBCDataSources1: TODBCDataSources;
    ODBCTables1: TODBCTables;
    procedure FormCreate(Sender: TObject);
    procedure BrowseExtHstmtAfterFirst(Sender: TObject);
    procedure OEDBNavigator1ReturnToBrowse(Sender: TObject);
    procedure BrowseExtHstmtBeforeDelete(Sender: TObject;
      var bUpdate: Boolean);
    procedure BrowseExtHstmtBeforePost(Sender: TObject;
      var bUpdate: Boolean);
    procedure BrowseExtHstmtError(Sender: TObject; Msg: string;
      Operation: THstmtOperations);
    procedure BrowseExtHstmtInsert(Sender: TObject;
      var iContinue: Boolean);
    procedure BrowseExtHstmtAfterInsert(Sender: TObject);
    procedure BrowseExtHstmtAfterCancel(Sender: TObject);
  private
    { Private declarations }
    FSN: NullString;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
TRY
 OEGrid1.BindParamCore(1, SQL_C_CHAR, @FSN, SQL_CHAR);
 BrowseExtHstmt.PopulateOn(Form1, True);
 BrowseExtHstmt.Prepare;
 BrowseExtHstmt.Execute;
 OEDBNavigator1.DataSource := BrowseExtHstmt;
 OEDBNavigator1.BtnClick(nbFirst);
EXCEPT
 on ODBCError do
    begin
      Henv1.Error.GetNext;
      Henv1.Error.Display;
      Application.MessageBox('This demo requires the TESTACCESS32 Datasource', 'Demo Error', MB_OK);
   end;
 END;
end;

procedure TForm1.BrowseExtHstmtAfterFirst(Sender: TObject);
var
 i:WORD;
begin
{Note that we use the OEDBNavigator DataSource Property to get the data
 from the currently connect ExtHstmt}
 StrPCopy(FSN, OEDBNavigator1.DataSource.ColString(1));
 for i:= 1 to OEGrid1.ColCount do
     OEGrid1.Cells[i, 1] := '';
 OEGrid1.Populate;
end;

procedure TForm1.BrowseExtHstmtBeforeDelete(Sender: TObject;
  var bUpdate: Boolean);
begin
if Application.MessageBox('This is the BeforeDelete Event of the ExtHstmt, Delete?','ExtHstmt', mb_OKCancel +
    mb_DefButton1) = IDCANCEL then bUpdate := False;
end;

procedure TForm1.BrowseExtHstmtBeforePost(Sender: TObject;
  var bUpdate: Boolean);
var
 Msg: String;
begin
Msg := 'This is the BeforePost (Update) Event of the ExtHstmt.  ' +
       'There is also a ' +
       'BeforeRefresh, BeforeDelete, AfterPost, AfterUpdate, and AfterRefresh';
 Application.MessageBox(PCHAR(Msg),'ExtHstmt',mb_OK);
end;

procedure TForm1.BrowseExtHstmtError(Sender: TObject; Msg: string;
  Operation: THstmtOperations);
begin
 Application.MessageBox(PChar(Msg), 'ODBC Error', MB_OK);
end;

procedure TForm1.BrowseExtHstmtInsert(Sender: TObject;
  var iContinue: Boolean);
var
 newSN, newUser: String;
begin
 iContinue := False;
 TRY
 If Not InputQuery('New User', 'Enter the Student Number for the New Student', newSN) then
    exit;
 if newSN = '' then exit;
 {do any other validation here}
 Try
  StrToInt(newSN);
 Except
  on EConvertError do begin
   Application.MessageBox('Must be number, ie 12345678', 'Error', MB_OK);
   exit;
  end;
 End;
 If Not InputQuery('New User', 'Enter the Name of the New Student', newUser) then
    exit;
 if newUser = '' then exit;

 InsertExtHstmt.Terminate;
 InsertExtHstmt.SQL := 'INSERT INTO Students (SNo, SName, SGender) VALUES (''' +
 newSN + ''', ''' + newUser + ''', 0)';
 InsertExtHstmt.Prepare; InsertExtHstmt.Execute;
 InsertExtHstmt.Terminate;
 InsertExtHstmt.SQL := 'SELECT SNo, SName FROM Students WHERE SNo = ''' + newSN + '''';
 InsertExtHstmt.Prepare; InsertExtHstmt.Execute;
 iContinue := True;
 EXCEPT
  on ODBCError do
    begin
      Henv1.Error.GetNext;
      Henv1.Error.Display;
   end;
 END;
end;

procedure TForm1.BrowseExtHstmtAfterInsert(Sender: TObject);
begin
 OEDBNavigator1.DataSource := InsertExtHstmt;
 BrowseExtHstmt.PopulateOff;
 InsertExtHstmt.PopulateOn(Form1, True);
 OEDBNavigator1.BtnClick(nbFirst);
 {The OEDBNavigator is now using the 'InsertHstmt' to manipulate data.
  The InsertHstmt should only have one record in its result set(the one inserted).
  When ODBC version 3 comes out we can do away with this and use FetchFind to
  position our selfs at the inserted record.  When the user presses any of the
  navigate buttons the OnReturnToBrowse method will be triggered, there we set
  the OENavigator back to using the BrowseHstmt.
 }
end;

procedure TForm1.OEDBNavigator1ReturnToBrowse(Sender: TObject);
begin
 OEDBNavigator1.DataSource := BrowseExtHstmt;
 InsertExtHstmt.PopulateOff;
 BrowseExtHstmt.PopulateOn(Form1, True);
 BrowseExtHstmt.DoRefresh;
 {Work around for OE 'feature' of not refreshing visual components, this is
  only temporary, shouldn't be needed}
 OEEdit1.Text := BrowseExtHstmt.ColString(1);
 OEEdit2.Text := BrowseExtHstmt.ColString(2);
end;

procedure TForm1.BrowseExtHstmtAfterCancel(Sender: TObject);
begin
 {Work around for OE 'feature' of not refreshing visual components, this is
  only temporary, shouldn't be needed}
 OEEdit1.Text := BrowseExtHstmt.ColString(1);
 OEEdit2.Text := BrowseExtHstmt.ColString(2);
end;

end.
