unit Dbfrm1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Cryptcon, Blowunit, StdCtrls, Grids, DBGrids, DB,
  DBTables, Buttons;

type
  TTstFrm = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    SecretInfoEdit: TEdit;
    BlowFish1: TBlowFish;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    NewKeyEdit: TEdit;
    Edit1: TEdit;
    Edit2: TEdit;
    SpeedButton1: TSpeedButton;
    Edit3: TEdit;
    Edit4: TEdit;
    SpeedButton2: TSpeedButton;
    procedure DBGrid1DrawDataCell(Sender: TObject; const Rect: TRect;
      Field: TField; State: TGridDrawState);
    procedure SecretInfoEditKeyPress(Sender: TObject; var Key: Char);
    procedure Table1BeforePost(DataSet: TDataset);
    procedure FormCreate(Sender: TObject);
    procedure NewKeyEditKeyPress(Sender: TObject; var Key: Char);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
    FEncryptKey: String; {The key which is used to encrypt data in the db}
    FNewSecretValue: Boolean;
  public
    { Public declarations }
  end;

var
  TstFrm: TTstFrm;
Const
  ENCRYPTED_FIELD = 'SecretUserInfo';
implementation

uses HexStr, String16, DbEncrt;
{$R *.DFM}

procedure TTstFrm.DBGrid1DrawDataCell(Sender: TObject; const Rect: TRect;
  Field: TField; State: TGridDrawState);
var
 Decytpword: array[0..255]   of char;
 encryptStr: String[255];

begin
  if (gdFocused in State) then
  begin
     if (Field.FieldName = ENCRYPTED_FIELD) then
     begin
       {Position the Edit box}
       SecretInfoEdit.Left := Rect.Left + DBGrid1.Left;
       SecretInfoEdit.Top := Rect.Top + DBGrid1.top;
       SecretInfoEdit.Height := Rect.Bottom - Rect.Top;
       SecretInfoEdit.Width := Rect.Right - Rect.Left;
       {decode db field here}
       Blowfish1.InputType := SourceByteArray;
       encryptStr := Table1.FieldByName(ENCRYPTED_FIELD).AsString;
       If FEncryptKey <> '' then begin {stored encrypted}
       TRY
        Hexstr.HexStrToBytes(encryptStr, @Decytpword);
        Blowfish1.InputLength := Length(encryptStr) DIV 2;
        Blowfish1.pInputArray := @Decytpword;
        Blowfish1.pOutputArray := @Decytpword;
        Blowfish1.Key := FEncryptKey;
        Blowfish1.DecipherData(False);
        SetLength(encryptStr, Blowfish1.InputLength);
        Move(Decytpword, encryptStr[1], Blowfish1.InputLength);
       EXCEPT
       on EConvertError do
       END;
       end;
       {stored in the clear}
       SecretInfoEdit.MaxLength := 16;
       SecretInfoEdit.Text := encryptStr;
       SecretInfoEdit.Visible := True;
       SecretInfoEdit.SetFocus;
       SecretInfoEdit.SelectAll;
     end
     Else
       SecretInfoEdit.Visible := False;
  end;{gfocus}

end;

procedure TTstFrm.SecretInfoEditKeyPress(Sender: TObject; var Key: Char);
begin
 If (key = chr(9)) Or (key = chr(13)) then begin
  SecretInfoEdit.Visible := False;
  Table1.Edit;
  Table1.FieldByName(ENCRYPTED_FIELD).AsString := SecretInfoEdit.Text;
  FNewSecretValue := True;
  Table1.Post;
 end;
end;

procedure TTstFrm.Table1BeforePost(DataSet: TDataset);
var
 Encytpword: array[0..255] of char;
 encryptStr: String[255];
begin
 if FNewSecretValue then begin
  FNewSecretValue := False;
  if (Length(FEncryptKey) > 0) then begin
   Blowfish1.InputType := SourceString;
   Blowfish1.InputString := Table1.FieldByName(ENCRYPTED_FIELD).AsString;
   Blowfish1.pOutputArray := @Encytpword;
   Blowfish1.Key := FEncryptKey;
   Blowfish1.EncipherData(False);
   Hexstr.BytesToHexStr(encryptStr, @Encytpword, Blowfish1.InputLength);
   Table1.FieldByName(ENCRYPTED_FIELD).AsString := encryptStr;
  end;
 end;
end;

procedure TTstFrm.FormCreate(Sender: TObject);
begin
 FEncryptKey := InputBox('Test DB Encryption', 'Please Enter the Key to Encrypt/Decrypt'
  + #13#10 + 'the database field with', '');
 {note place checks here to ensure that the FEncryptKey is good}
 FNewSecretValue := False;
end;

procedure TTstFrm.NewKeyEditKeyPress(Sender: TObject; var Key: Char);
var
 iTable: TTable;
begin
 {ReEncrpt the contents of the SecretUserInfo column of the database with
  the new key}
 {this will be done with none visual components}
  If (key = chr(13)) then begin
    iTable := TTable.Create(nil);
    Screen.Cursor := crHourglass;
    TRY
     iTable.DatabaseName := Table1.DatabaseName;
     iTable.TableName := Table1.TableName;
     DbEncrt.ChangeKey(iTable, ENCRYPTED_FIELD, FEncryptKey, NewKeyEdit.Text);
    FINALLY
     iTable.Free;
     Screen.Cursor := crDefault;
     Table1.Refresh;
     FEncryptKey := NewKeyEdit.Text;
     MessageDlg('Key changed to ' + NewKeyEdit.Text, mtInformation, [mbOK], 0);
    END;
  end;
end;

procedure TTstFrm.SpeedButton1Click(Sender: TObject);
var
 Blow: TBlowfish;
 InputStr: String;
begin
 Blow:= TBlowfish.Create(nil);
 TRY
  Blow.CipherMode := ECBMode;
  Blow.Key := 'PutYourKeyHere';
  InputStr := Edit1.Text;
  if Not EncryptStr(InputStr, Blow) then begin
    MessageDlg('Error encrypting text',  mtInformation, [mbOK], 0);
    exit;
  end;
  Edit2.Text := InputStr;
  Edit4.Text := InputStr;
 FINALLY
  Blow.Free;
 END;
end;

procedure TTstFrm.SpeedButton2Click(Sender: TObject);
var
 Blow: TBlowfish;
 InputStr: String;
begin
 Blow:= TBlowfish.Create(nil);
 TRY
  Blow.CipherMode := ECBMode;
  Blow.Key := 'PutYourKeyHere';
  InputStr := Edit4.Text;
  if Not DecryptStr(InputStr, Blow) then begin
    MessageDlg('Error encrypting text', mtInformation, [mbOK], 0);
    exit;
  end;
  Edit3.Text := InputStr;
 FINALLY
  Blow.Free;
 END;

end;

end.
