unit Hexstr;

interface
uses String16, SysUtils;

Type
 PByte = ^BYTE;

procedure BytesToHexStr(var encryptStr: String; Encytpword: PByte; InputLength: WORD);
procedure HexStrToBytes(encryptStr: String; Encytpword: Pointer);
procedure HexBytesToChar(var Response: String; hexbytes: PChar; InputLength: WORD);

implementation
procedure BytesToHexStr(var encryptStr: String; Encytpword: PByte; InputLength: WORD);
Const
    HexChars : Array[0..15] of Char = '0123456789ABCDEF';
var
    i, j: WORD;
begin
 FillChar(encryptStr, SizeOf(encryptStr), #0);
 SetLength(encryptStr, (InputLength * 2));
 j := 1;
 for i := 1 to InputLength  do begin
  encryptStr[j] := Char(HexChars[Encytpword^ shr  4]); inc(j);
  encryptStr[j] := Char(HexChars[Encytpword^ and 15]); inc(j);
  inc(Encytpword);
 end;
end;
procedure HexBytesToChar(var Response: String; hexbytes: PChar; InputLength: WORD);
var
 i: WORD;
 c: byte;
begin
 FillChar(Response, SizeOf(Response), #0);
 SetLength(Response, InputLength);
 for i := 0 to (InputLength - 1) do begin
   c := BYTE(hexbytes[i]) And BYTE($f);
   if c > 9 then
     Inc(c, $37)
   else
     Inc(c, $30);
   Response[i + 1] := char(c);
 end;{for}
end;

procedure HexStrToBytes(encryptStr: String; Encytpword: Pointer);
var
 i, j: WORD;
 tempPtr: PChar;
 twoDigits : String[2];
begin
 tempPtr := Encytpword;
 {FillChar(PChar(tempPtr)^, 127, #0);}
 j := 1;
 for i := 1 to (Length(encryptStr) DIV 2) do begin
   twoDigits := Copy(encryptStr, j, 2); Inc(j, 2);
   PByte(tempPtr)^ := StrToInt('$' + twoDigits); Inc(tempPtr);
 end;{for}
end;

end.
