unit Dbencrt;
{The ChangeKey function can be called to encrypt a database column.  Pass in
 the Old key (zero length means that the column is not currently encrypted), and
 the new key to encrypt it with (again, passing in a zero length NewKey will cause
 the column to be stored in the clear).  Pass in a TTable structure and the name
 of the field to encrypt.

 The EncryptStr function can  be used to encrypt a str, and return a STRING.  Note
 the max length of an input string is 127 in Delphi 1.  This is because the out
 string is converted to a 'hexstr' so that there are no problems with no printable
 characters.  A 'hexstr' requires that each char be converted to two digits.

 The DecryptStr function takes a 'hexstr' as input and returns a string.

 For each of EncryptStr and DecryptStr pass in a descendent of TCrypto.

 -----------------------------------------------------------------------------
 Code Author:  Greg Carter, gregc@cryptocard.com
 Organization: CRYPTOCard Corporation, info@cryptocard.com
               R&D Division, Carleton Place, ON, CANADA, K7C 3T2
               1-613-253-3152 Voice, 1-613-253-4685 Fax.
 Date:  June. 29 1996.
}

interface
uses Cryptcon, Blowunit, DB, DBTables, HexStr, String16, SysUtils;

Function ChangeKey(TableToUpdate: TTable; FieldToUpdate, OldKey, NewKey: String): Boolean;
Function EncryptStr(var InputStr: String; CryptoCom: TCrypto): Boolean;
Function DecryptStr(var InputStr: String; CryptoCom: TCrypto): Boolean;

implementation
Function EncryptStr(var InputStr: String; CryptoCom: TCrypto): Boolean;
{Setup CryptoCom the way you wish the encryption to be performed, ie
 the cipher mode, ivector,.. you do NOT need to set the output array}
var
 Decytpword: array[0..254]   of char;
 encryptStr: String[255];
begin
 Result := True;
 TRY
  CryptoCom.InputType := SourceString;
  CryptoCom.InputString := InputStr;
  CryptoCom.pOutputArray := @Decytpword;
  CryptoCom.EncipherData(False);
  Hexstr.BytesToHexStr(InputStr, @Decytpword, CryptoCom.InputLength);
 EXCEPT
  Result := False;
 END;
end;

Function DecryptStr(var InputStr: String;CryptoCom: TCrypto): Boolean;
var
 Decytpword: array[0..254]   of char;
 Encrypt: array[0..254]   of char;
 encryptStr: String[255];
begin
  Result := True;
  FillChar(Encrypt, SizeOf(Encrypt), #0);
  TRY{HexStrToBytes could throw up an exception trying to convert}
   Hexstr.HexStrToBytes(InputStr, @Decytpword);
   CryptoCom.InputType := SourceByteArray;
   CryptoCom.InputLength := Length(InputStr) DIV 2;
   CryptoCom.pInputArray := @Decytpword;
   CryptoCom.pOutputArray := @Encrypt;
   CryptoCom.DecipherData(False);
   InputStr := StrPas(Encrypt);
  EXCEPT
   Result := False;
  END;
end;
Function ChangeKey(TableToUpdate: TTable; FieldToUpdate, OldKey, NewKey: String): Boolean;
{Note This uses the blowfish algorithm, it could easily be changed to use any descendent
 of TCrypto, see EncryptStr or DecryptStr for examples}
var
 Decytpword: array[0..254]   of char;
 encryptStr: String[255];
 Blowfish1: TBlowfish;

begin
 Blowfish1 := TBlowfish.Create(nil);
 With TableToUpdate do begin
  Active := True;
  First;
  while Not EOF do begin
   encryptStr := TableToUpdate.FieldByName(FieldToUpdate).AsString;
   TRY
    {decode with old key}
    If (Length(OldKey) > 0) then begin {stored encrypted}
     Hexstr.HexStrToBytes(encryptStr, @Decytpword);
     Blowfish1.InputType := SourceByteArray;
     Blowfish1.InputLength := Length(encryptStr) DIV 2;
     Blowfish1.pInputArray := @Decytpword;
     Blowfish1.pOutputArray := @Decytpword;
     Blowfish1.Key := OldKey;
     Blowfish1.DecipherData(False);
     SetLength(encryptStr, Blowfish1.InputLength);
     Move(Decytpword, encryptStr[1], Blowfish1.InputLength);
    end;
    {encode with new Key}
    if Length(NewKey) > 0 then begin {store encrypted}
     Blowfish1.InputType := SourceString;
     Blowfish1.InputString := encryptStr;
     Blowfish1.pOutputArray := @Decytpword;
     Blowfish1.Key := NewKey;
     Blowfish1.EncipherData(False);
     Hexstr.BytesToHexStr(encryptStr, @Decytpword, Blowfish1.InputLength);
    end;
    Try
     Edit;
     TableToUpdate.FieldByName(FieldToUpdate).AsString := encryptStr;
     Post;
    Except
     on EDatabaseError do
    End;
   EXCEPT
    on EConvertError do
   END;
   Next;
  end;{while}
  First;
 end;{with}

 Blowfish1.Free;
end;
end.
