/* ssl/ssltest.c */
/* Copyright (C) 1995-1996 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "buffer.h"
#include "crypto.h"
#include "../e_os.h"
#include "x509.h"
#include "ssl.h"
#include "err.h"

#ifdef WIN16
#define APPS_WIN16
#include "../crypto/buffer/bss_file.c"
#endif

#define TEST_SERVER_CERT "../apps/server.pem"
#define TEST_CLIENT_CERT "../apps/client.pem"

#ifndef NOPROTO
int MS_CALLBACK verify_callback(int ok, X509 *xs, X509 *xi, int depth,
	int error,char *arg);
#else
int MS_CALLBACK verify_callback();
#endif

BIO *bio_err=NULL;
BIO *bio_stdout=NULL;

static char *cipher=NULL;
int verbose=0;
#ifdef FIONBIO
static int s_nbio=0;
#endif


#ifndef  NOPROTO
int doit(SSL_CTX *s_ctx,SSL_CTX *c_ctx);
#else
int doit();
#endif

static void sv_usage()
	{
	fprintf(stderr,"usage: ssltest [args ...]\n");
	fprintf(stderr,"\n");
	fprintf(stderr," -server_auth  - check server certificate\n");
	fprintf(stderr," -client_auth  - do client authentication\n");
	fprintf(stderr," -v            - more output\n");
	fprintf(stderr," -CApath arg   - PEM format directory of CA's\n");
	fprintf(stderr," -CAfile arg   - PEM format file of CA's\n");
	}

int main(argc, argv)
int argc;
char *argv[];
	{
	char *CApath=NULL,*CAfile=NULL;
	int badop=0;
	int ret=1;
	int client_auth=0;
	int server_auth=0;
	SSL_CTX *s_ctx=NULL;
	SSL_CTX *c_ctx=NULL;

	if (bio_err == NULL)
		if ((bio_err=BIO_new(BIO_s_file())) != NULL)
			BIO_set_fp(bio_err,stderr,BIO_NOCLOSE);
	if (bio_stdout == NULL)
		if ((bio_stdout=BIO_new(BIO_s_file())) != NULL)
			BIO_set_fp(bio_stdout,stdout,BIO_NOCLOSE);

	CRYPTO_mem_ctrl(CRYPTO_MEM_CHECK_ON);

	argc--;
	argv++;

	while (argc >= 1)
		{
		if	(strcmp(*argv,"-server_auth") == 0)
			server_auth=1;
		else if	(strcmp(*argv,"-client_auth") == 0)
			client_auth=1;
		else if	(strcmp(*argv,"-CApath") == 0)
			{
			if (--argc < 1) goto bad;
			CApath= *(++argv);
			}
		else if	(strcmp(*argv,"-CAfile") == 0)
			{
			if (--argc < 1) goto bad;
			CAfile= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		sv_usage();
		goto end;
		}

	if (cipher == NULL) cipher=getenv("SSL_CIPHER");

	SSL_load_error_strings();

	c_ctx=SSL_CTX_new();
	s_ctx=SSL_CTX_new();
	if ((c_ctx == NULL) || (s_ctx == NULL))
		goto end;

	SSL_CTX_use_certificate_file(s_ctx,TEST_SERVER_CERT,SSL_FILETYPE_PEM);
	SSL_CTX_use_RSAPrivateKey_file(s_ctx,TEST_SERVER_CERT,SSL_FILETYPE_PEM);

	if (client_auth)
		{
		SSL_CTX_use_certificate_file(c_ctx,TEST_CLIENT_CERT,
			SSL_FILETYPE_PEM);
		SSL_CTX_use_RSAPrivateKey_file(c_ctx,TEST_CLIENT_CERT,
			SSL_FILETYPE_PEM);
		}

	if (	(!SSL_load_verify_locations(s_ctx,CAfile,CApath)) ||
		(!SSL_set_default_verify_paths(s_ctx)) ||
		(!SSL_load_verify_locations(c_ctx,CAfile,CApath)) ||
		(!SSL_set_default_verify_paths(c_ctx)))
		{
		fprintf(stderr,"SSL_load_verify_locations\n");
		ERR_print_errors(bio_err);
		goto end;
		}

	if (client_auth)
		{
		fprintf(stderr,"client authentication\n");
		SSL_CTX_set_verify(s_ctx,
			SSL_VERIFY_PEER|SSL_VERIFY_FAIL_IF_NO_PEER_CERT,
			verify_callback);
		}
	if (server_auth)
		{
		fprintf(stderr,"server authentication\n");
		SSL_CTX_set_verify(c_ctx,SSL_VERIFY_PEER,
			verify_callback);
		}

	ret=doit(s_ctx,c_ctx);
end:
	if (s_ctx != NULL) SSL_CTX_free(s_ctx);
	if (c_ctx != NULL) SSL_CTX_free(c_ctx);

	if (bio_stdout != NULL) BIO_free(bio_stdout);

	ERR_remove_state(0);
	CRYPTO_mem_leaks(bio_err);
	EXIT(ret);
	}

#define W_READ	1
#define W_WRITE	2
#define C_DONE	1
#define S_DONE	2

int doit(s_ctx,c_ctx)
SSL_CTX *s_ctx,*c_ctx;
	{
	static char cbuf[200],sbuf[200];
	SSL *c_ssl=NULL;
	SSL *s_ssl=NULL;
	BIO *c_to_s=NULL;
	BIO *s_to_c=NULL;
	BIO *c_bio=NULL;
	BIO *s_bio=NULL;
	int c_r,c_w,s_r,s_w;
	int c_want,s_want;
	int i;
	int done=0;
	int c_write,s_write;
	int do_server=0,do_client=0;

	c_ssl=SSL_new(c_ctx);
	s_ssl=SSL_new(s_ctx);
	if ((s_ssl == NULL) || (c_ssl == NULL)) goto err;

	c_to_s=BIO_new(BIO_s_mem());
	s_to_c=BIO_new(BIO_s_mem());
	if ((s_to_c == NULL) || (c_to_s == NULL)) goto err;

	c_bio=BIO_new(BIO_f_ssl());
	s_bio=BIO_new(BIO_f_ssl());
	if ((c_bio == NULL) || (s_bio == NULL)) goto err;

	SSL_set_connect_state(c_ssl);
	SSL_set_bio(c_ssl,s_to_c,c_to_s);
	BIO_set_ssl(c_bio,c_ssl,BIO_CLOSE);

	SSL_set_accept_state(s_ssl);
	SSL_set_bio(s_ssl,c_to_s,s_to_c);
	BIO_set_ssl(s_bio,s_ssl,BIO_CLOSE);

	c_r=0; s_r=1;
	c_w=1; s_w=0;
	c_want=W_WRITE;
	s_want=0;
	c_write=1,s_write=0;

	/* We can always do writes */
	for (;;)
		{
		do_server=0;
		do_client=0;

		i=(int)BIO_pending(s_bio);
		if ((i && s_r) || s_w) do_server=1;

		i=(int)BIO_pending(c_bio);
		if ((i && c_r) || c_w) do_client=1;

		if (do_server && verbose)
			{
			if (SSL_in_init(s_ssl))
				printf("server waiting in SSL_accept - %s\n",
					SSL_state_string_long(s_ssl));
			else if (s_write)
				printf("server:SSL_write()\n");
			else 
				printf("server:SSL_read()\n");
			}

		if (do_client && verbose)
			{
			if (SSL_in_init(c_ssl))
				printf("client waiting in SSL_connect - %s\n",
					SSL_state_string_long(c_ssl));
			else if (c_write)
				printf("client:SSL_write()\n");
			else
				printf("client:SSL_read()\n");
			}

		if (!do_client && !do_server)
			{
			fprintf(stdout,"ERROR IN STARTUP\n");
			ERR_print_errors(bio_err);
			break;
			}
		if (do_client && !(done & C_DONE))
			{
			if (c_write)
				{
				i=BIO_write(c_bio,"hello from client\n",18);
				if (i < 0)
					{
					c_r=0;
					c_w=0;
					if (BIO_should_retry(c_bio))
						{
						if (BIO_should_read(c_bio))
							c_r=1;
						if (BIO_should_write(c_bio))
							c_w=1;
						}
					else
						{
						fprintf(stderr,"ERROR in CLIENT\n");
						ERR_print_errors(bio_err);
						return(1);
						}
					}
				else if (i == 0)
					{
					fprintf(stderr,"SSL CLIENT STARTUP FAILED\n");
					return(1);
					}
				else
					{
					/* ok */
					c_write=0;
					}
				}
			else
				{
				i=BIO_read(c_bio,cbuf,100);
				if (i < 0)
					{
					c_r=0;
					c_w=0;
					if (BIO_should_retry(c_bio))
						{
						if (BIO_should_read(c_bio))
							c_r=1;
						if (BIO_should_write(c_bio))
							c_w=1;
						}
					else
						{
						fprintf(stderr,"ERROR in CLIENT\n");
						ERR_print_errors(bio_err);
						return(1);
						}
					}
				else if (i == 0)
					{
					fprintf(stderr,"SSL CLIENT STARTUP FAILED\n");
					return(1);
					}
				else
					{
					done|=C_DONE;
					fprintf(stdout,"CLIENT:from server:");
					fwrite(cbuf,1,i,stdout);
					fflush(stdout);
					}
				}
			}

		if (do_server && !(done & S_DONE))
			{
			if (!s_write)
				{
				i=BIO_read(s_bio,sbuf,100);
				if (i < 0)
					{
					s_r=0;
					s_w=0;
					if (BIO_should_retry(s_bio))
						{
						if (BIO_should_read(s_bio))
							s_r=1;
						if (BIO_should_write(s_bio))
							s_w=1;
						}
					else
						{
						fprintf(stderr,"ERROR in SERVER\n");
						ERR_print_errors(bio_err);
						return(1);
						}
					}
				else if (i == 0)
					{
					fprintf(stderr,"SSL SERVER STARTUP FAILED\n");
					return(1);
					}
				else
					{
					s_write=1;
					s_w=1;
					fprintf(stdout,"SERVER:from client:");
					fwrite(sbuf,1,i,stdout);
					fflush(stdout);
					}
				}
			else
				{
				i=BIO_write(s_bio,"hello from server\n",18);
				if (i < 0)
					{
					s_r=0;
					s_w=0;
					if (BIO_should_retry(s_bio))
						{
						if (BIO_should_read(s_bio))
							s_r=1;
						if (BIO_should_write(s_bio))
							s_w=1;
						}
					else
						{
						fprintf(stderr,"ERROR in SERVER\n");
						ERR_print_errors(bio_err);
						return(1);
						}
					}
				else if (i == 0)
					{
					fprintf(stderr,"SSL SERVER STARTUP FAILED\n");
					return(1);
					}
				else
					{
					s_write=0;
					s_r=1;
					done|=S_DONE;
					}
				}
			}

		if ((done & S_DONE) && (done & C_DONE)) break;
		}

	fprintf(stdout,"DONE\n");
err:
	/* We have to set the BIO's to NULL otherwise they will be
	 * Free()ed twice.  Once when th s_ssl is SSL_free()ed and
	 * again when c_ssl is SSL_free()ed.
	 * This is a hack required because s_ssl and c_ssl are sharing the same
	 * BIO structure and SSL_set_bio() and SSL_free() automatically
	 * BIO_free non NULL entries.
	 * You should not normally do this or be required to do this */
	s_ssl->rbio=NULL;
	s_ssl->wbio=NULL;
	c_ssl->rbio=NULL;
	c_ssl->wbio=NULL;

	if (c_to_s != NULL) BIO_free(c_to_s);
	if (s_to_c != NULL) BIO_free(s_to_c);
	if (c_bio != NULL) BIO_free(c_bio);
	if (s_bio != NULL) BIO_free(s_bio);
	return(0);
	}

int MS_CALLBACK verify_callback(ok, xs, xi, depth, error, arg)
int ok;
X509 *xs;
X509 *xi;
int depth;
int error;
char *arg;
	{
	char *s;

	s=(char *)X509_NAME_oneline(X509_get_subject_name(xs));
	if (s != NULL)
		{
		if (ok)
			fprintf(stderr,"depth=%d %s\n",depth,s);
		else
			fprintf(stderr,"depth=%d error=%d %s\n",depth,error,s);
		Free(s);
		}

	return(ok);
	}

