#!/bin/sh

echo "#define DATE      \"`date`\"" >crypto/date.h

major="0"
minor="6.4"
slib=libssl
clib=libcrypto
CC=gcc
FLAGS='-DTERMIO -O3 -DL_ENDIAN -fomit-frame-pointer -m486 -Wall'
#FLAGS='-DTERMIO -g -DL_ENDIAN -m486 -Wall'
INCLUDE='-Iinclude -Icrypto -Issl'
SHFLAGS='-DPIC -fpic'

CFLAGS="$FLAGS $INCLUDE $SHFLAGS"

echo compiling bignum assember
as -o bn_asm.o crypto/bn/asm/x86-lnx.s
CFLAGS="$CFLAGS -DASM"

echo compiling $clib
$CC -c $CFLAGS -DCFLAGS="\"$FLAGS\"" -o crypto.o crypto/crypto.c

echo linking $clib.so
gcc -shared -Wl,-soname,$clib.so.$major -o $clib.so.$major.$minor crypto.o bn_asm.o

echo compiling $slib.so
$CC -c $CFLAGS -o ssl.o ssl/ssl.c

echo building $slib.so
gcc -shared -Wl,-soname,$slib.so.$major -o $slib.so.$major.$minor ssl.o
