/* lib/buf/buf_err.c */
/* Copyright (C) 1995-1996 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SS
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIA
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include "err.h"
#include "buffer.h"

/* BEGIN ERROR CODES */
static ERR_STRING_DATA BUF_str_functs[]=
	{
{ERR_PACK(0,BUF_F_BIO_CTRL,0),	"BIO_ctrl"},
{ERR_PACK(0,BUF_F_BIO_GETS,0),	"BIO_gets"},
{ERR_PACK(0,BUF_F_BIO_NEW,0),	"BIO_new"},
{ERR_PACK(0,BUF_F_BIO_PUTS,0),	"BIO_puts"},
{ERR_PACK(0,BUF_F_BIO_READ,0),	"BIO_read"},
{ERR_PACK(0,BUF_F_BIO_WRITE,0),	"BIO_write"},
{ERR_PACK(0,BUF_F_BUF_MEM_GROW,0),	"BUF_MEM_grow"},
{ERR_PACK(0,BUF_F_BUF_MEM_NEW,0),	"BUF_MEM_new"},
{ERR_PACK(0,BUF_F_FILE_CTRL,0),	"FILE_CTRL"},
{ERR_PACK(0,BUF_F_MEM_WRITE,0),	"MEM_WRITE"},
{0,NULL},
	};

static ERR_STRING_DATA BUF_str_reasons[]=
	{
{BUF_R_BAD_FOPEN_MODE                    ,"bad fopen mode"},
{BUF_R_NULL_PARAMETER                    ,"null parameter"},
{BUF_R_UNINITALISED                      ,"uninitalised"},
{BUF_R_UNSUPPORTED_METHOD                ,"unsupported method"},
{0,NULL},
	};

void ERR_load_BUF_strings()
	{
	static int init=1;

	if (init)
		{
		init=0;
		ERR_load_strings(ERR_LIB_BUF,BUF_str_functs);
		ERR_load_strings(ERR_LIB_BUF,BUF_str_reasons);
		}
	}
