 
DILARCHI.C 0            @@/          00   @@TEXTMACA       L  blY                       _  /*
 *  File:       DILArchive.c
 *
 *  Contains:   Windows code to archive strings and frames sent from the Newton PDA DILArchive 
 *              Transport.
 *              
 *  Written by: W. Aric Kollmyer, Aric@Kollmyer.org
 *              based on the SoupDrink code written by Rob Langhorne
 *
 *  Copyright:   1996 by Apple Computer, Inc.  All rights reserved.
 *
 *  Change History (most recent first):
 *
 *  Purpose:
 *
 *  Notes:
 *          This is nearly all of the Windows-specific code.  It is not intended to be
 *          good Windows sample code :-)  but it works to provide a face for archiving Newton PDA
 *          strings and frames.
 *
 *  Nearly all of the DIL code can be found in Protocol.c.
 */
 
#include <string.h>
#include <stdio.h>
#include <windows.h>
#include <commdlg.h>

#include "DILCPipe.h"
#include "HLFDIL.h"
#include "DILArchive.h"
#include "Protocol.h"

#define Timeout 600                // this is Window timeout in msecs


long FAR PASCAL  WndProc (HWND, UINT, UINT, LONG) ;
BOOL FAR PASCAL  AboutDlgProc (HWND, UINT, UINT, LONG) ;
BOOL FAR PASCAL  StatusDlgProc (HWND, UINT, UINT, LONG) ;

/******** Global variables **********/              
BOOL            gQuit ;                             /* Flags for application state*/
BOOL            asyncRead ;                         /* Should we always read asynchronously? */
int             gNumPorts ;                         // how many ports are in our port menu
long            gWhichPort ,                        /* which port (printer, modem, printer-modem) */
                gWhichTool ;                        /* Selector for which Communications Toolbox tool to use */
CDIL_State      gOldState = kCDIL_Uninitialized;    /* state of the pipe */
void            *ourPipe = 0;
void            *anotherObject ;
char            gTempBuffer [256] ;                 /* a global string buffer for input dialogs, etc */
short           gXferMode ;                         /* receive strings or frames */
extern FILE     *gArchFile ;
char            szAppName [] = "DilArchive" ;
char            gMessageText [255] ;
HANDLE FAR      gXInst ;
HWND            gWindow ;
HWND            gStatus ;
static HANDLE   hInstance , inputInstance ;
FARPROC         gInputProc ;
int             gInputMode ;
char            gReceivedString[1000] ;
int             gReceivedStringLen ;
void            *gThisObject ;

void PostAlertMessage(char*a, char*b, char*c, char*d)
{
    char s[2000];
    
    sprintf(s, "%s%s%s%s", a,b,c,d); 
    MessageBox (0, s, "DilArchive", MB_ICONEXCLAMATION | MB_OK) ;
}

/*
 * WinMain
 *
 * Purpose:    This is the entry point for this application.
 */
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{   
    HWND     hwnd ;
    MSG      msg ;
    WNDCLASS wndclass ;
    CommErr  err;

    if (!hPrevInstance) 
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
        wndclass.lpfnWndProc   = WndProc ;
        wndclass.cbClsExtra    = 0 ;
        wndclass.cbWndExtra    = 0 ;
        wndclass.hInstance     = hInstance ;
        wndclass.hIcon         = LoadIcon (hInstance, "DilArchive") ;
        wndclass.hCursor       = LoadCursor (0, IDC_ARROW) ;
        wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
        wndclass.lpszMenuName  = szAppName ;
        wndclass.lpszClassName = szAppName ;

        RegisterClass (&wndclass) ;
    }

    strcpy( gMessageText, "");     // clear out gMessageText
    gXInst = hInstance;

    hwnd = CreateWindow (szAppName, "DilArchive",
                         WS_OVERLAPPEDWINDOW,
                         CW_USEDEFAULT, CW_USEDEFAULT,
                         CW_USEDEFAULT, CW_USEDEFAULT,
                         HWND_DESKTOP, 0, hInstance, NULL) ;

    ShowWindow (hwnd, nCmdShow) ;
    UpdateWindow (hwnd) ;

    gWindow = hwnd;

// *** YOUR CODE TO OPEN THE CDIL LIBRARY GOES HERE

// *** YOUR CODE TO CREATE THE CDIL OBJECT GOES HERE

    while (TRUE)
    {
        if (PeekMessage (&msg, 0, 0, 0, PM_REMOVE))
        {      
            if (msg.message == WM_QUIT)
            {
                break;
            }
            
            if(gStatus == 0 || !IsDialogMessage(gStatus, &msg))
            {
                TranslateMessage (&msg) ;
                DispatchMessage (&msg) ;
            }
        }  
        else
        {   //  Perform idle processing
            if (ourPipe)
            {
                CDIdle (ourPipe);
                UpdateStatus();
            }
        }       
    }

// *** YOUR CODE TO DISPOSE OF THE CDIL OBJECT AND CLOSE CDIL LIBRARY GOES HERE
        
    return msg.wParam ;
}

/*
 * WndProc
 *
 * Purpose: This is the main window's message loop.
 */
long FAR PASCAL  WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
    static FARPROC  lpfnAboutDlgProc ;
    static FARPROC  lpfnInputDlgProc ;
    HMENU           hMenu ;
    Boolean         eom = false;
    CommErr         err;
    int i = 0;
                             
    switch (message)
    {      
        case WM_CREATE: //window is being created do all initialization code here
        {
            hInstance = ((LPCREATESTRUCT) lParam)->hInstance ;

            lpfnAboutDlgProc = MakeProcInstance ((FARPROC) AboutDlgProc,
                                                    hInstance) ;
 
            hMenu = GetMenu (hwnd) ;
            EnableMenuItem(hMenu, IDM_CONNECT, MF_BYCOMMAND | MF_ENABLED);
            EnableMenuItem(hMenu, IDM_DISCONNECT, MF_BYCOMMAND | MF_GRAYED);
                
            SetupPortMenu(hMenu);
            return 0 ;
        }
        case WM_COMMAND: // a menu items has been selected by the user
        {   
            hMenu = GetMenu (hwnd) ;

            switch (wParam)
            {   
                case IDM_EXIT: //user has selected to end the program
                {
                    SendMessage (hwnd, WM_CLOSE, 0, 0L) ;
                    return 0 ;
                }   
                case IDM_CONNECT: //Connect to Newton
                {
                    err = InitializePipe();
                    if( err )
                    {   
                        PostAlertMessage ( "Error Connecting to Newton: ", ErrorStrings((int)err, gTempBuffer), "", "" );
                    }
                    else
                    {                                           
                        err = DoConnectPipe ();
                        if ( err )
                        {        
                            PostAlertMessage ( "Error Connecting to Newton: ", ErrorStrings((int)err, gTempBuffer), "", "" );
                        }
                        else 
                        {
                            //Change menu to reflect the change in connection state
                            hMenu = GetMenu (hwnd) ;
                            EnableMenuItem(hMenu, IDM_DISCONNECT, MF_BYCOMMAND | MF_ENABLED);
                            EnableMenuItem(hMenu, IDM_CONNECT, MF_BYCOMMAND | MF_GRAYED);
                            PostAlertMessage("Connect Succesful!", "", "", "");
                        }   
                    return 0 ;  
                }   
                case IDM_DISCONNECT: //Disconnect from Newton
                {
					// ***YOUR CODE TO DISCONNECT GOES HERE
                    hMenu = GetMenu (hwnd) ;
                    
                    //Change menu to reflect the change in the connection state
                    EnableMenuItem(hMenu, IDM_CONNECT, MF_BYCOMMAND | MF_ENABLED);
                    EnableMenuItem(hMenu, IDM_DISCONNECT, MF_BYCOMMAND | MF_GRAYED);
                    break;
                }   
                case IDM_ARCHIVE: //Do an Archive with the newton
                {
                    //Change menu to reflect the change in the connection state.
                    hMenu = GetMenu (hwnd) ;
                    EnableMenuItem(hMenu, IDM_ARCHIVE, MF_BYCOMMAND | MF_GRAYED);
                 
                    //Do the archive, as this is a Blocking function and will not return until
                    //the archive is done.
                    err = Archive();
                        
                    EnableMenuItem(hMenu, IDM_ARCHIVE, MF_BYCOMMAND | MF_ENABLED);
                    if (err)   
                    {   
                        PostAlertMessage("Error Archiving", ErrorStrings( err, gTempBuffer), "", "");
                    }
                    break;
                }    
                case IDM_ABOUT: //display the about box
                {
                    DialogBox (hInstance, "AboutBox", hwnd, lpfnAboutDlgProc) ;
                    return 0 ;
                }   
                case IDM_COM_1:
                case IDM_COM_2:
                case IDM_COM_3:
                case IDM_COM_4:
                case IDM_COM_5:
                case IDM_COM_6:
                case IDM_COM_7:
                case IDM_COM_8:
                case IDM_COM_9:
                {   
                    //A new com port has been selected, so remove the check mark from the 
                    //old one.
                    for(i = 1; i <= 9; i++)
                    {   
                        CheckMenuItem(hMenu, IDM_COM_1 + i - 1, MF_UNCHECKED | MF_BYCOMMAND);
                    };
                    
                    //And Check the new one.
                    CheckMenuItem(hMenu, wParam, MF_CHECKED | MF_BYCOMMAND);
                        
                    return 0;
                }       
            };
            
            break ;
        }
        case WM_DESTROY : //Window is about to be destroyed 
        {   
            PostQuitMessage (0) ;
            return 0 ;
        }
    };
    
    return DefWindowProc (hwnd, message, wParam, lParam) ;
}

/*
 * AboutDlgProc
 *
 * Purpose: A simple windows proc to allow the use of the about box.
 */
BOOL FAR PASCAL AboutDlgProc (HWND hDlg, UINT message, UINT wParam, LONG lParam)
{   
    switch (message)
    {
        case WM_INITDIALOG:
        {   
            return TRUE ;
        }
        case WM_COMMAND:
        {   
            switch (wParam)
            {   
                case IDOK:
                case IDCANCEL:
                {   
                    EndDialog (hDlg, 0) ;     
                    return TRUE ;
                }      
            };
            
            break ;
        }
    };  
    return FALSE ;
}

/*
 * StatusDlgProc
 *
 * Purpose: A simple windows proc to allow for a status window
 */
BOOL FAR PASCAL  StatusDlgProc (HWND hDlg, UINT message, UINT wParam, LONG lParam)
{   
    switch (message)
    {   
        case WM_INITDIALOG:
        {   
            return TRUE ;
        }

    };
    
    return FALSE ;
};

/*
 * EventLoop
 *
 * Purpose: To make Windows edition of code compatable with the Mac code.
 */
void EventLoop ( void )
{   
    UpdateStatus();
}

// SetupPortMenu() demonstrates finding the available ports available on your machine.
// If the port cannot be opened the the port is removed from the menu. Windows 3.x only
// allows up to 9 ports so we don't need to worry about anymore. If this code is
// ever ported to a 32-bit edition of Windows then you need to worry about more ports.
//
void SetupPortMenu(HMENU hMenu)
{   
    int     port = 0, i;
    char    comPort[10];
    UINT    item = 0; 

    for(i = 9; i >= 1; i--)
    {
        //try to open the port.
        sprintf(comPort, "Com%i", i);
        port = 0;
        port = OpenComm(comPort, 1024, 128);
        
        if(port >= 0)
        {
            //Port was opened, therefor it exists.
            CloseComm(port);
            item = (IDM_COM_1 + i - 1);
        }
        else
        {   
            //Port was not opened, remove the menu item from the list.
            DeleteMenu(hMenu, (IDM_COM_1 + i - 1), MF_BYCOMMAND);
        }
        port = 0;        
    }        
    
    if(item)
    {
        //Set the default port to the first available COM port.
        CheckMenuItem(hMenu, item, MF_CHECKED | MF_BYCOMMAND);
    }
}

/*
 * InitializePipe
 *
 * Purpose: This function sets up port options for the CDIL function called CDPipeInit.
 *
 * Note that if you do not "dispose" of the connection, the port can be locked and you will
 * get the "port busy" error which will make life difficult for both you and users. It would
 * be best if the function which Initializes the pipe takes responsibility for disposing of
 * of the pipe. This should happen in EndArchive if all goes well.
 */
CommErr InitializePipe ()
{   
    char    comPort[256];
    char    comString[256];
    int i = 0;
    int item = 0;
    CommErr  err;
    HMENU hMenu = GetMenu(gWindow);
    hMenu = GetSubMenu(hMenu, 2);
    
    //find out which COM port the user has selected.
    for(i = 1; i <= 9; i++)
    {   
        if(GetMenuState(hMenu, IDM_COM_1 + i - 1, MF_BYCOMMAND) & MF_CHECKED)
        {
            //if the COM port menu item is checked then the user has selected it.
            item = i;
            break;
        }
        
    };
    
    if(item)
    {
        //create parameters used to select the COM port
        sprintf(comString, "COM%i:38400,n,8,1", item);
        sprintf(comPort, "COM%i", item);               
        
		// ***YOUR CODE TO INIT DEVICE GOES HERE
    }
    else
    {
        err = kPipeNotReady;
    }

    return err;
}

/* StateStrings
 *
 * Purpose: return state string based on state number from the CDILs
 * (as a pascal string)
 * note, if theErr is greater than 50, it is a user CDIL error
 */
char* StateStrings(int theState, char *theString)
{
    char* str;
    char theNum[128];
    switch (theState) 
    {
        case kCDIL_Uninitialized:       str = "CDIL is unitialized."; break;
        case kCDIL_InvalidConnection:   str = "CDIL tried to bring up connection, but it failed."; break;
        case kCDIL_Disconnected:        str = "CDIL is not connected."; break;
        case kCDIL_Listening:           str = "CDIL is listening for a connection."; break;
        case kCDIL_ConnectPending:      str = "A connection is pending."; break;
        case kCDIL_Connected:           str = "CDIL is connected."; break;
        case kCDIL_Busy:                str = "CDIL is either reading or writing."; break;
        case kCDIL_Aborting:            str = "CDIL is currently aborting."; break;
        case kCDIL_Startup:             str = "CDIL is currently starting up."; break;
        default:                        str = (theState < 50) ? "Unknown CDIL state." : "(User-defined CDIL state)";
    };  
    
    sprintf(theString, "%s: State #%u", str, theNum);

    return theString;
}

/*
 * CreateStatusDlog
 *
 * Purpose: put up a dialog which is used to describe the state of the CDIL pipe and the
 *                  archive process
 */
void CreateStatusDlog ()
{
    gStatus = CreateDialog(hInstance, "StatusBox", gWindow, MakeProcInstance(StatusDlgProc, hInstance));
}

/*
 * UpdateStatus
 *
 * Purpose: updates the status dialog - called periodically from DoIdle routine and
 *                     on demand during archiving process as archive state changes
 */
void UpdateStatus ()
{
    CDIL_State      cur_state;
    char            stateText[256];
    
    if ( gStatus )
    {
        if ( ourPipe )
        {   
			// ***YOUR CODE TO UPDATE STATUS GOES HERE
/*			if (  ***YOUR CODE TO TEST IF PIPE IS DISCONNECTED ) 
            { // tear down dialog if connection is gone
                gOldState = kCDIL_Disconnected;
                DestroyWindow (gStatus) ;
                gStatus = 0;   
            } 
            else 
            {
				// ***YOUR CODE TO SET cur_state TO BE CURRENT STATE OF PIPE 
                if ( cur_state != gOldState )
                { //stat of connection has changed update the status dialog 
                    gOldState = cur_state;
                    StateStrings( cur_state, stateText );
                    SetDlgItemText( gStatus, IDC_STATUS, stateText );
                }
            }
*/        
		}
    }
}

/*
 * SetArchiveStatus
 *
 * Purpose: To make Windows edition of code compatable with the Mac code.
 */
void  SetArchiveStatus ( short archiveState )
{
    UpdateStatus();
}

/*
 * CreateFileName
 *
 * Purpose: platform specific routine to get name for new file and location to create file in.
 *          Used when user want to create new archive
 */
CommErr CreateFileName ( char *name )
{
    CommErr                         err = (CommErr)kCommErrNoErr;
    
    OPENFILENAME ofn;

    char szDirName[256];
    char szFile[256], szFileTitle[256];
    char  szFilter[256] = "All Files\0*.*\0\0";

    /* Get the system directory name, and store in szDirName */
    GetSystemDirectory(szDirName, sizeof(szDirName));
    szFile[0] = '\0';

    /* Set all structure members to zero. */
    memset(&ofn, 0, sizeof(OPENFILENAME));

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = gWindow;
    ofn.lpstrFilter = szFilter;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile= szFile;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = sizeof(szFileTitle);
    ofn.lpstrInitialDir = szDirName;
    ofn.lpstrTitle = "Archive As";
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;

    //Presents a system standard dialog for the user to create/select a file
    if (GetOpenFileName(&ofn)) 
    {
        /* Perform file operations. */
        _fstrcpy(name, ofn.lpstrFile);
        
    }
    else
    {
        err = kOurUserCancelled;
    }

    return err;
}

/*
 * GetFileName
 *
 * Purpose: platform specific routine to get specific file name and location from user.
 *          Used when user want to create open existing archive.
 */
CommErr GetFileName ( char *name )
{
    CommErr                         err = kCommErrNoErr;

    OPENFILENAME ofn;

    char szDirName[256];
    char szFile[256], szFileTitle[256];
    char  szFilter[256] = "All Files\0*.*\0\0";

    /* Get the system directory name, and store in szDirName */
    GetSystemDirectory(szDirName, sizeof(szDirName));
    szFile[0] = '\0';

    /* Set all structure members to zero. */
    memset(&ofn, 0, sizeof(OPENFILENAME));

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = gWindow;
    ofn.lpstrFilter = szFilter;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile= szFile;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = sizeof(szFileTitle);
    ofn.lpstrInitialDir = szDirName;
    ofn.lpstrTitle = "Send File";
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

    //Presents a system standard dialog for the user to select a file
    if (GetOpenFileName(&ofn)) 
    {
        /* Perform file operations. */
        _fstrcpy(name, ofn.lpstrFile);
        
    }
    else
    {
        err = kOurUserCancelled;
    }

    return err;
}
        
                                                                                                                                      T   T   F2KSXYK%S \X BiEDiiEDY
DILARCHI.C   TEXTMACA     TEXTMACA                   b  J  DYX  "ERX " DYYKS \X #jED %jEDYX@ #ERX #@DYYKS \Xz#ED##EDYX  zERX z DYYKS \XED#EDYX	 ERX 	DY   H 	Monaco                             HR HR4s      g           T   T   Fh    F MPSR   MWBB              L                                                                                                          