/*
	File:		HLFDIL.h

	Contains:	Definitions of the DIL Object class.
				This includes the DIL variable-to-object binding definitions

	Written by:	Rob Langhorne

  	Copyright c 1995 Apple Computer, Inc.
  	All rights reserved.

	Change History (most recent first):  
		  version 1.0 Universal Headers	
	To Do:

*/

#ifndef __DILFDIL_H
#define __DILFDIL_H

#ifndef __DILPIPE_H
	#include "DILCPipe.h"
#endif

#if GENERATINGPOWERPC
#pragma options align=mac68k
#endif

/*-------------------------------------------------------------------------
**
**	Definitions
**
** ------------------------------------------------------------------------ */

#define objErr 			long				/*	Object method error returns								*/
#define unicodeFactor 	2		/*	Adjustment factor for buffers in unicode conversions	*/

#define TDIL_REFERENCE 8  /*  The reference used is circular										*/

/*-------------------------------------------------------------------------
**	Local Error Codes	
** ------------------------------------------------------------------------ */

#define kobjErrNoErr		0							/*	No error						*/

#define kFDILErrBase		(-800 + -28000)				/*	FDIL Error code base number		*/

#define kObjectHeapNoMemory		(-1 + kFDILErrBase)			/*	Out of heap memory				*/
#define kTempNoMemory								(-2 + kFDILErrBase)			/*	Out of other memory				*/
#define kUnknownSlot									(-3 + kFDILErrBase)			/*	Slot not known					*/
#define kSlotSizeExceeded				(-4 + kFDILErrBase)			/*	Slot defined size exceeded		*/
#define kSlotSizeRequired				(-5 + kFDILErrBase)			/*	A required slot size is missing	*/
#define kUnexpectedDataType 	(-6 + kFDILErrBase)		 /*	The data type we received was unexpected	*/

/*-------------------------------------------------------------------------
**	DIL Variable types
** ------------------------------------------------------------------------ */
enum kDILSlotTypes {
	  kDILImmediate,								/*	Indeterminate Immediate type	 */
	  kDILCharacter,								/*	ASCII Character					          */
	  kDILUnicodeCharacter,	/*	Unicode Character				         */
	  kDILBinaryObject,					/*	Small Binary Object ( < 32K )	*/
	  kDILArray,												/*	Named Array						             */
  	kDILPlainArray,							/*	Anonymous Array					          */
  	kDILFrame,								    /*	Frame							                  */
  	kDILSymbol,				       /*	Object Symbol					            */
  	kDILString,				       /*	String (null-terminated)		    */
  	kDILPrecedent,			     /*	Repeated Item				            	*/
  	kDILNIL,				          /*	nil object						              */
  	kDILSmallRect,			     /*	Small rect						              */
	  kDILBLOB,				         /*	Large Binary Object				       */
  	kDILBoolean,			       /*	Boolean						                	*/
  	kDILInteger				       /*	Integer (4 byte)			          	*/
};

// shorter definition for unsigned long
typedef unsigned long ulong;

// DIL Object
typedef void FAR DILObj;

/*-------------------------------------------------------------------------
**	DIL Object slot type	
** ------------------------------------------------------------------------ */

typedef struct	slotDefinition
{
	short		varType   ;		/*	Data type of this variable			     */
	void 		*var 	    ;		/*	Actual variable pointer				       */
	ulong		length	   ;		/*	Length of this variable (strings)	*/
	ulong		maxLength ;		/*	Maximum Length of this variable		 */
	ulong		streamLen ;		/*	Length of streaming this slot		   */	/* Internal	*/
	ulong		bufIndex  ;		/*	Current buffer index				          */	/* Internal	*/
	long 		namePrec  ;		/*	Is this the original precedent 	 	*/	/* Internal	*/
	long 		classPrec ;		/*	Is this the original precedent 	 	*/	/* Internal	*/
	char		 *slotName ;		/*	Name of slot for this bind var		  */
	char		 *oClass	  ;		/*	class of this compound object		   */
	short		slotType  ;		/*	Data type of this slot				        */		
	ulong		truncSize ;		/*	Current size of truncated object	 */
	long		 childCnt  ;		/*	Number of child nodes				         */
	long		 peerCnt	  ;		/*	Number of peer nodes				          */
	short	 dataFilled;		/*	Set to TRUE if data has been added in this
									slot in this operation				                       */
	long		internalFlags;	/*	Internal state flags				         */
	short 	boundData ;	  /* for future use                   */
	struct	slotDefinition	*children ;
	struct	slotDefinition	*next ;
}	slotDefinition ;

/*-------------------------------------------------------------------------
**		DILObject Class
** ------------------------------------------------------------------------ */
#ifdef __cplusplus
extern "C" {
		/*	object maintenance	*/
		objErr PASCAL 	FDbindSlot		( DILObj *DILobj, char *slotName, void   *bindVar, short varType, long maxLen, long curLen = -1, char *objClass = nil ) ;
#else
		objErr PASCAL 	FDbindSlot		( DILObj *DILobj, char *slotName, void   *bindVar, short varType, long maxLen, long curLen, char *objClass ) ;
#endif

		/*	~~~~~ object communications	*/
		objErr PASCAL FDput ( DILObj *DILobj, short objectType, CDILPipe *pipe );
		objErr PASCAL FDget ( DILObj *DILobj, short objectType, CDILPipe *pipe, long timeOut, CDILPipeCompletionProcPtr completionHook,long refCon);

		/*	~~~~~ unbound list operations	*/
		slotDefinition * PASCAL FDGetUnboundList	( DILObj *DILobj ) ;
		objErr 			 PASCAL FDFreeUnboundList	( DILObj *DILobj, slotDefinition *desc ) ;
		
		
#ifdef __cplusplus
}	 /* DILObject	*/
#endif

/*-------------------------------------------------------------------------
**		Basic functions
** ------------------------------------------------------------------------ */
#ifdef __cplusplus
extern "C" {
#endif
   objErr	PASCAL FDInitFDIL 		( void );
   objErr 	PASCAL FDDisposeFDIL 	( void ) ;
   DILObj  *PASCAL FDCreateObject 	( short objectType, char *objectClass ) ;
   objErr	PASCAL FDDisposeObject 	( DILObj *DILobj )	;
#ifdef __cplusplus
}
#endif

#endif	/* __DILFDIL_H */
