/*

 * Protocol.h

 *   Header file for protocol.c, part of the DILArchive  sample application for 

 * Newton Programming: Communications 2.0 class

 * Copyright 1996 by Apple Computer, Inc. All rights reserved

 *

 */



// added call to end archive

#ifndef CHECKDILERROR

#define CHECKDILERROR(x); {CommErr retVal = (x); if (retVal) { EndArchive(retVal, true); CDPipeDisconnect (ourPipe) ; return (retVal); }}

#endif



#define kStrings 0

#define kFrames 1



#define kMAXSTR 255 

#define kNumRetries 5

#define kTimeoutInSecs 30

#define Encoding 0

#define Swapping 0



#define kMaxNumDILObjs  64



/****** Function prototypes  *******/

#ifdef forMac   // ****** stuff for MAC-OS applications ******
long            CurrentTimeInSeconds(); // platform-specific; found in archive.c or ARCHIVE.C
#endif

char*           ErrorStrings(CommErr theErr, char* theString);

CommErr         ReadFromPipe ( char *response, long *length, long swapping );

CommErr         WriteToPipe ( char *message, long *length, long swapping );

CommErr         Archive ( void );

CommErr         DoArchive ( char *msg );

CommErr         DoDearchive ( char *msg );

CommErr         DoConnectPipe (void);

CommErr         CreateArchiveFile( short type );

CommErr         OpenArchiveFile( void );

CommErr         ArchiveString ( char *response );

CommErr         DearchiveString ( char *to_str );

CommErr         EndArchive ( CommErr endState, Boolean sending );

objErr          WriteFrameToFile ( DILObj *theObject );

void            PrintFrame ( slotDefinition *thisEntry );

void            PrintSlot ( slotDefinition *thisEntry );

CommErr         CleanUpMemory ( void );

CommErr         DearchiveFrame ( DILObj *cur_obj, Boolean isArray );

void            TerminateDearchive ( void );



