/*
	File:		DILErrors.h

	Contains:	A collection of the possible error codes returned from the DILs

	Written by:	Rob Langhorne

	Copyright:	c1996 by Apple Computer, Inc.  All rights reserved.

	Change History (most recent first):
				<1>	7/10/96	rob		Initial code		

*/

#ifndef __DILERRORS_H__
#define __DILERRORS_H__

/*-------------------------------------------------------------------------
**	CDIL Error Codes	
** ------------------------------------------------------------------------ */

#define kDILErrBase 					(-700 + -28000)			/*	Error code base number							*/

#define kCommErrNoErr					0						/*	No error										*/
#define kOutOfMemory					(-1 + kDILErrBase)		/*	Error on memory allocation						*/
#define kBadPipeState					(-2 + kDILErrBase)		/*	DIL Pipe was set to a bad state					*/
#define kExceptionErr					(-3 + kDILErrBase)		/*	An unhandled exception was raised				*/
#define kQueueFullError					(-4 + kDILErrBase)		/*	async completion queue is full					*/
#define kPipeNotInitialized				(-5 + kDILErrBase)		/*	Pipe has not been initialized					*/
#define kInvalidParameter				(-6 + kDILErrBase)		/*	A parameter passed in was invalid				*/
#define kPipeNotReady					(-7 + kDILErrBase)		/*	Pipe is not ready for operation					*/
#define kTimeout						(-8 + kDILErrBase)		/* 	A timeout has occurred							*/
#define kBadAsyncEntry					(-9 + kDILErrBase)		/* 	A bad asynchronous enty has been added 			*/
#define kBadTrafficCopID				(-10 + kDILErrBase)		/* 	The Traffic Cop has lost your id  				*/
#define kCSTRNotFound					(-11 + kDILErrBase)		/*	The required CSTR resource was not found 		*/

/*-------------------------------------------------------------------------
**	FDIL Error Codes	
** ------------------------------------------------------------------------ */
#define kobjErrNoErr					0							/*	No error									*/

#define kFDILErrBase					(-800 + -28000)				/*	FDIL Error code base number					*/

#define kObjectHeapNoMemory				(-1 + kFDILErrBase)			/*	Out of heap memory							*/
#define kTempNoMemory					(-2 + kFDILErrBase)			/*	Out of other memory							*/
#define kUnknownSlot					(-3 + kFDILErrBase)			/*	Slot not known								*/
#define kSlotSizeExceeded				(-4 + kFDILErrBase)			/*	Slot defined size exceeded					*/
#define kSlotSizeRequired				(-5 + kFDILErrBase)			/*	A required slot size is missing				*/
#define kUnexpectedDataType 			(-6 + kFDILErrBase)		 	/*	The data type we received was unexpected	*/
#define kExhaustedData       			(-7 + kFDILErrBase)		 	/*	We have exhausted available data			*/

/*-------------------------------------------------------------------------
**	DIL Memory Error Codes	
** ------------------------------------------------------------------------ */

#define kBuffErrNoErr			0							/*	No error						*/

#define kBuffErrBase			(-820 + -28000)				/*	Buffer Error code base number		*/
#define kBufferMemoryError  	(-1 + kBuffErrBase)			/*	Out of memory					*/
#define kBufferOverflowError  	(-2 + kBuffErrBase)			/*	Out of buffer					*/
#define kBufferUnderflowError  	(-3 + kBuffErrBase)			/*	Out of buffer					*/
#define kBufferBadPosition	  	(-4 + kBuffErrBase)			/*	Bad buffer position					*/
#define kBufferBadParameter		(-5 + kBuffErrBase)

/*-------------------------------------------------------------------------
**	PDIL Error Codes	
** ------------------------------------------------------------------------ */

#define kPDILErrBase 					(-900 + -28000)				/*	 PDIL Error code base number				*/

#define kProtocolExtensionUndefined		(-1 + kPDILErrBase)			/*	 The specified PDIL extension is unknown	*/
#define kDisconnection					(-2 + kPDILErrBase)			/*	 A disconnection was determined				*/
#define kBadDataInHeader				(-3 + kPDILErrBase)			/*	 There was bad data in the command header	*/
#define kNoCommand						(-4 + kPDILErrBase)			/*	 No command is waiting						*/
#define kBadData						(-5 + kPDILErrBase)			/*	 Bad or missing data in command				*/
#define kBadListEntry					(-6 + kPDILErrBase)			/*	 Bad or missing list entry					*/
#define kBadPassword					(-7 + kPDILErrBase)			/*	 The password was bad						*/
#define kInvalidPDILState				(-8 + kPDILErrBase)			/*	 Invalid PDIL state for operation			*/

#endif	/* __DILERRORS_H__ */
