/*
 * hook.h.proto: header for hook.c
 * 
 * Generated from hook.h.proto by source/Makefile
 *
 * @(#)$Id: hook.h.proto,v 1.10 1994/10/16 01:29:14 mrg Stab $
 */

#ifndef __hook_h_
# define __hook_h_

/* Hook: The structure of the entries of the hook functions lists */
typedef struct	hook_stru
{
	struct	hook_stru *next;	/* pointer to next element in list */
	char	*nick;			/* The Nickname */
	int	not;			/* If true, this entry should be
					 * ignored when matched, otherwise it
					 * is a normal entry */
	int	noisy;			/* flag indicating how much output
					 * should be given */
	int	server;			/* the server in which this hook
					 * applies. (-1 if none). If bit 0x1000
					 * is set, then no other hooks are
					 * tried in the given server if all the
					 * server specific ones fail
					 */
	int	sernum;			/* The serial number for this hook. This
					 * is used for hooks which will be
					 * concurrent with others of the same
					 * pattern. The default is 0, which
					 * means, of course, no special
					 * behaviour. If any 1 hook suppresses
					 * the * default output, output will be
					 * suppressed.
					 */
	char	*stuff;			/* The this that gets done */
	int	global;			/* set if loaded from `global' */
}	Hook;

/* HookFunc: A little structure to keep track of the various hook functions */
typedef struct
{
	char	*name;			/* name of the function */
	Hook	*list;			/* pointer to head of the list for this
					 * function */
	int	params;			/* number of parameters expected */
	int	mark;
	unsigned flags;
}	HookFunc;

/*
 * NumericList: a special list type to dynamically handle numeric hook
 * requests 
 */
typedef struct numericlist_stru
{
	struct	numericlist_stru *next;
	char	*name;
	Hook	*list;
}	NumericList;

#define	ACTION_LIST $
#define	CHANNEL_NICK_LIST $
#define CHANNEL_SIGNOFF_LIST $
#define CONNECT_LIST $
#define CTCP_LIST $
#define CTCP_REPLY_LIST $
#define	DCC_CHAT_LIST $
#define DCC_CONNECT_LIST $
#define DCC_ERROR_LIST $
#define DCC_LOST_LIST $
#define	DCC_RAW_LIST $
#define DCC_REQUEST_LIST $
#define DISCONNECT_LIST $
#define ENCRYPTED_NOTICE_LIST $
#define ENCRYPTED_PRIVMSG_LIST $
#define EXEC_LIST $
#define EXEC_ERRORS_LIST $
#define EXEC_EXIT_LIST $
#define EXEC_PROMPT_LIST $
#define EXIT_LIST $
#define FLOOD_LIST $
#define HELP_LIST $
#define	HOOK_LIST $
#define IDLE_LIST $
#define INPUT_LIST $
#define INVITE_LIST $
#define JOIN_LIST $
#define LEAVE_LIST $
#define LIST_LIST $
#define MAIL_LIST $
#define MODE_LIST $
#define MSG_LIST $
#define MSG_GROUP_LIST $
#define NAMES_LIST $
#define NICKNAME_LIST $
#define NOTE_LIST $
#define NOTICE_LIST $
#define NOTIFY_SIGNOFF_LIST $
#define NOTIFY_SIGNON_LIST $
#define PUBLIC_LIST $
#define PUBLIC_MSG_LIST $
#define PUBLIC_NOTICE_LIST $
#define PUBLIC_OTHER_LIST $
#define	RAW_IRC_LIST $
#define	SEND_ACTION_LIST $
#define	SEND_DCC_CHAT_LIST $
#define SEND_MSG_LIST $
#define SEND_NOTICE_LIST $
#define SEND_PUBLIC_LIST $
#define	SEND_TALK_LIST $
#define	SERVER_NOTICE_LIST $
#define SIGNOFF_LIST $
#define	TALK_LIST $
#define TIMER_LIST $
#define TOPIC_LIST $
#define WALL_LIST $
#define WALLOP_LIST $
#define WHO_LIST $
#define WIDELIST_LIST $
#define WINDOW_LIST $
#define WINDOW_KILL_LIST $
#define KICK_LIST $

#ifdef ON_KICK
# define NUMBER_OF_LISTS KICK_LIST + 1
#else
# define NUMBER_OF_LISTS WINDOW_KILL_LIST + 1
#endif 

#ifdef USE_STDARG_H
extern	int	do_hook(int, char *, ...);
#else
extern	int	do_hook();
#endif
extern	void	save_hooks();
extern	char	*hook_info;
extern	void	remove_hook();
extern	void	show_hook();

extern	NumericList *numeric_list;
extern	HookFunc FAR hook_functions[];

extern	int	in_on_who;

#endif /* __hook_h_ */
