/* IRC 2 startup file. Assumes Rexx is installed.
   Copyright 1994-95 V. Phaniraj -- phaniraj@badlands.nodak.edu

   This is the startup file for Irc2.exe for OS/2. It requires IBM TCP/IP 
   and OS/2 Version 2.0 and above. 
*/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

/* default just in case it's not in ini file */
LINES=25 
COLUMNS=80
INI_VERSION = "0.50"

Parse source with . ThisProg .
ThisPath = left(ThisProg,Lastpos('\',ThisProg)-1)
irc_inifile = ThisPath || '\irc2.ini'

rc = stream(irc_inifile,'c','query exists')
if rc = '' Then
   '@setup.exe'

rc=SysIni(irc_inifile,'IRC/2','ALL:','names')
do i = 1 to names.0
   val=SysIni(irc_inifile,'IRC/2',names.i)
   if right(val, 1) = '00'x then
      val=left(val, length(val) - 1)
   interpret names.i '= val'
end

call value 'IRCCMD',VERSION,'OS2ENVIRONMENT'
Parse Arg Args

'@mode co'COLUMNS','LINES

errfile = SysTempFileName(ThisPath'\errout.???')
'@if exist' ThisPath'\rawlog.tx4 del' ThisPath'\rawlog.tx4 > NUL'
'@if exist' ThisPath'\rawlog.tx3 ren' ThisPath'\rawlog.tx3' 'rawlog.tx4 > NUL'
'@if exist' ThisPath'\rawlog.tx2 ren' ThisPath'\rawlog.tx2' 'rawlog.tx3 > NUL'
'@if exist' ThisPath'\rawlog.tx1 ren' ThisPath'\rawlog.tx1' 'rawlog.tx2 > NUL'
'@if exist' ThisPath'\rawlog.txt ren' ThisPath'\rawlog.txt' 'rawlog.tx1 > NUL'

irc_exe_file = ThisPath || '\irc2.exe'
start = date(U) time()
rc = SysFileTree(irc_exe_file, file_list)

if file_list.0 = 0 then 
 Do
  say  'The irc2.exe file was not found. Please check the directory'
  say  'in which Irc/2 was installed.'
  rc=SysSleep(2)
  Exit
 End

xx=pos('&',Args)
if xx <>0 then Args=insert('^',Args,xx-1)
xx1=pos('&',Args)
if xx1 > xx+1 then Args=insert('^',Args,xx1-1)
xx2=pos('&',Args)
if xx2>xx1+1 then Args=insert('^',Args,xx2-1)

'@'irc_exe_file Args '2>' errfile

if stream(errfile,C,'query size') = 0 Then 
Do
    '@del' errfile ' > NUL'
     Exit
End

   '@type' errfile ' >> irc2err.dat'

   mailfile = SysTempFileName(ThisPath'\tempmail.???')
   logfile = ThisPath'\rawlog.txt'

   rc = lineout(mailfile, 'Subject: IRC/2 v'||Value('IRCCMD',,'OS2ENVIRONMENT')||' Crash')
   rc = lineout(mailfile, '')
   rc = lineout(mailfile, 'Session started' start)
   rc = lineout(mailfile, '')
   rc = lineout(mailfile, 'Crashed at' date(U) time())
   rc = lineout(mailfile, '')
   rc=stream(mailfile, 'c', 'close');

   '@type' errfile '>>' mailfile
   '@del' errfile ' > NUL'

   say ''
   say 'IRC/2 has exited with an error condition.  Information regarding this error'
   say 'will automatically be mailed to <irc2bugs@invlogic.com> so we may explore'
   say 'the cause of this problem, and fix it for our next release.  Sendmail will'
   say 'be run shortly to assist in this process.'
   say ''
  
   etc=translate(value('ETC',,'OS2ENVIRONMENT'))
   parse var etc root'\ETC'
   umail=root||'\UMAIL'

   cfg=stream(etc'\sendmail.cf', 'C', 'Q EXISTS')
   if cfg = '' then do
      cfg = stream(etc'\sendmail.uml', 'C', 'Q EXISTS')
      if cfg <> '' then do
         parse var email userid '@' node

         if email="EMAIL" then do
            inputfile = umail'\umail.pro'
            fname=stream(inputfile,'C','Q EXISTS')
            If fname<>'' Then Do
               rc=stream(inputfile,'c','open read')
               k=0;
               do forever
                  inline=linein(inputfile)
                  if inline= '' then leave

                  parse var inline . ':USER' The_rest
                  if length(The_rest)<>0 Then Do
                     parse var The_rest . '=' "'"userid"'"
                     do forever
                        inline=linein(inputfile)
                        if inline= '' then leave

                        parse var inline . 'reply_domain' The_rest
 
                        if length(The_rest)<>0 Then Do
                           parse var The_rest . '=' "'"node"'"
                           Leave
                        End
                     end
                     leave
                  End
               end 
               rc=stream(inputfile, 'c', 'close');
            End
         End
  
         if (userid = "USERID") | (node = "NODE") then
            call fail
         else 
            '@sendmail -f'userid '-C'etc'\sendmail.uml -oMVrouter.invlogic.com -oMH'node 'irc2bugs@invlogic.com > nul <' mailfile
      end
      else 
         call fail
   end  
   else do
       mailfile2 = SysTempFileName(ThisPath'\tempmail.???')
       rc = lineout(mailfile2, 'From: "'name'" <'user'>')
       rc = lineout(mailfile2, 'Reply-to: ' email)
       rc=stream(mailfile2, 'c', 'close');
       '@type' mailfile '>>' mailfile2
      '@sendmail -f ' email '-t irc2bugs@invlogic.com > nul <' mailfile2
      '@del' mailfile2 '> NUL'
   end

   '@del' mailfile '> NUL'

Exit 0

fail: procedure
   say 'Unable to send error message to <irc2bugs@invlogic.com> because no valid'
   say 'sendmail configuration could be found to use.  Please take whatever steps'
   say 'are necessary to email the file' mailfile 'to the address shown above'
   say 'With your help, we can make IRC/2 a better program'
   '@pause'

   return
