/* */

 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
 call SysLoadFuncs

 rc=Say_Warning()
 rc=Handle_docs()
 rc=Handle_help()
 rc=Handle_script()
 rc=Handle_trans()
 rc=Save_files()
 Say 'Unzipping the distribution File'
 '@unzip  -qq -o distrib.zip' 
 If rc <> 0 Then rc=Say_error()
 rc=Is_hpfs()
 If rc = 1 Then '@unzip -qq -o hpfs.zip'
 If rc <> 0 Then rc=Say_error()
 Say 'Finished unzipping the distribution zip files, now cleaning up.'
 rc=Cleanup()
 rc=Restore_files()
 rc=Say_Info()
 rc=Run_setup()
exit

Say_Warning: Procedure
 Call SysCls
 say 'This install procedure does the following.'
 say '[1] Deletes the help, script, docs and translation sub-directories'
 say  '   if they exist.'
 say '[2] Unzips the distribution zip file, and help files'
 say '[3] Unzips extra help files if you are installing on HPFS'
 say '[4] Cleans up after itself'
 say '[5] Runs ircsetup.cmd to configure your irc session.'
 say ' '
 say 'If you wish to preserve files in some of these directories, then'
 say 'interrupt the install with Ctrl-break now.'
 say ' '
 say ' The files ircserv.txt, ircrc, and irc2.ini will be preserved'
 rc=SysSleep(2)
return 1

Handle_docs: Procedure
 curdir=directory()
 curdir=curdir'\docs\primer.txt'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\docs'
   '@delpath /y docs > nul'
 End 
return 1

Handle_help: Procedure
 curdir=directory()
 curdir=curdir'\help\cd'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\help'
   '@delpath /y help > nul'
 End 
return 1

Handle_script: Procedure
 curdir=directory()
 curdir=curdir'\script\channel'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\script'
   '@delpath /y script > nul'
 End 
return 1

Handle_trans: Procedure
 curdir=directory()
 curdir=curdir'\translation\ascii'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\translation'
   '@delpath /y translation > nul'
 End 
return 1


Save_files: Procedure
 fname=stream("ircrc",'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say ' Copying your ircrc to ircrc_.old'
 '@copy ircrc  ircrc_.old '
 End 

 fname=stream("irc2.ini",'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say ' Copying your irc2.ini to irc2_ini.old'
 '@copy irc2.ini irc2_ini.old '
 End 

 fname=stream("ircserv.txt",'C','Q EXISTS')
 If fname<>'' Then
  Do
   Say ' Copying your ircserv.txt to ircserv_.old'
   '@copy ircserv.txt ircserv_.old '
  End

return 1

Say_Error: Procedure
  Say ' '
  Say ' '
  Say 'An error occurred during unzippinmg the IRC/2 install files'
  Say 'The probable causes of this are insufficient disk space, '
  Say 'and corrupted or missing zip files.'
  Say 'Please check your disk space, and the zip file'
  rc=SysSleep(5)
  Exit
return 0

Is_HPFS: Procedure
 dname = systempfilename('junk.????')
 rc=sysmkdir(dname)
 If rc = 0 Then
  Do
   rc=sysrmdir(dname)
   return 1
  End
 Else
  return 0

Cleanup: Procedure
 del_file.1='distrib.zip'
 del_file.2='hpfs.zip'
 del_file.3='delpath.exe'
 del_file.4='unzip.exe'
 del_file.5='install.cmd'
 del_file.6='change.*'
 del_file.0=6
 
 do i=1 to del_file.0
   fname=stream(del_file.i,'C','Q EXISTS')
   if fname <>'' Then rc=SysFileDelete(del_file.i)
 End
return 1

Restore_files: Procedure
 Say 'Restoring any saved files'
 fname=stream("ircrc_.old",'C','Q EXISTS')
 say fname
 If fname <>'' Then 
 Do 
   Say ' Restoring ircrc '
  '@copy ircrc_.old ircrc '
  '@del ircrc_.old '
 End 

 fname=stream("irc2_ini.old",'C','Q EXISTS')
 If fname <>'' Then 
 Do 
   Say ' Restoring your irc2.ini'
 '@copy irc2_ini.old irc2.ini '
 '@del irc2_ini.old'
 End 

 fname=stream("ircserv_.old",'C','Q EXISTS')
 If fname <>'' Then
  Do
   Say ' Restoring your ircserv.txt'
   '@copy ircserv_.old ircserv.txt'
   '@del ircserv_.old '
  End

return 1

Say_Info: Procedure
 Call SysCls

 say 'Irc has now been installed, and the install procedure will '
 say 'now configure it, assuming you had not configured it previously.'
 say 'The configure procedure will create an object on your desktop '
 say 'which will run irc/2.  You can use this or irc.cmd to start irc/2'
 say ' '
 say 'Direct execution of irc2.exe is STRONGLY discouraged.'
 say ' '
 say 'If you wish to modify your irc/2 configuration after the initial '
 say 'installation, please run ircsetup.cmd'
 say ' '
 say 'ircsetup will now be automatically invoked if required'
 rc=SysSleep(15)
return 1


Run_setup: Procedure

 This_ircsetup_version = 3.0 
 IRCCMD=0.45

 fname=stream("irc2.ini",'C','Q EXISTS')
 If fname = '' Then 
  Do 
   Say ' Configuring irc/2'
  Call ircsetup
  rc = SysIni("irc2.ini",'irc/2','IRCCMD', IRCCMD)
  End
 Else
  Do
      rc = SysIni("irc2.ini",'irc/2','IRCCMD', IRCCMD)
      rc=SysIni("irc2.ini",'irc/2','ALL:','names')   
      do i = 1 to names.0
         val=SysIni("irc2.ini",'irc/2',names.i)
         interpret names.i '= val'
      end
      No_need_to_run = 0
      if Ircsetup_version = 'IRCSETUP_VERSION' Then No_need_to_run = 1
      else if Ircsetup_version < This_ircsetup_version Then No_need_to_run = 1
      if No_need_to_run = 1 Then Call Ircsetup

  End

return 1
