/*
	/dev/random - true random numbers
	/dev/urandom - cryptographically strong pseudorandom numbers
	
	This code is placed into public domain. No warranties. Caveat Hacker.
		
	supported ioctls:
	
	R_ZAP_COUNT (void) reset entropy counter
	R_ADD_COUNT (int *) increment entropy counter (after writing data)
	
	write and ioctl to this device should really be protected from
	normal processes, since we don't want an evil program to set the
	random bitpool to a predictable state. However, it's impossible
	to protect them now, and there has to be some method of putting
	in data.. :/
*/

#ifndef _RANDOM_H
#define _RANDOM_H

#ifndef _DRIVERS_H
#include <device/Drivers.h>
#endif

/* -----
	ioctl opcodes
----- */

enum {
	R_ZAP_COUNT = B_DEVICE_OP_CODES_END + 1,
	R_ADD_COUNT
};

#endif  /* _RANDOM_H */

