/*
	
	TypeChecker.cpp
	
	Copyright 1996 Jeremy Moskovich, Digital Reality Studios
	20-feb-96
	
	Jeremy@shape.co.il
	
	A simple program that displays the type and creator of a file
	dragged onto it...
	
*/

#include <Beep.h> //for beep
#include <OS.h> //for snooze

#ifndef HELLO_WINDOW_H
#include "HelloWindow.h"
#endif

#ifndef HELLO_VIEW_H
#include "HelloView.h"
#endif

#ifndef TYPE_CHANGER_H
#include "TypeChecker.h"
#endif

#include <string.h>
#include <stdlib.h>


main()
{

	ChangerApplication *myApplication;
	myApplication = new ChangerApplication();
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

ChangerApplication::ChangerApplication()
		  		  : BApplication('CHNG')
{
	
	BRect			aRect;

	// set up a rectangle and instantiate a new window
	aRect.Set(20, 20, 200, 60);
	resultWindow = new HelloWindow(aRect);
	
	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with left top at (0, 0)
	aRect.OffsetTo(B_ORIGIN);
	resultView = new HelloView(aRect, "FileNameView");
	
	// add view to window
	resultWindow->AddChild(resultView);
	
	// make window visible
	resultWindow->Show();
}

void ChangerApplication::RefsReceived( BMessage *message )
{
	ulong type;
	long count;
	
	//first get the number of database references in the record...
	message->GetInfo( "refs", &type, &count );
	
	//now loop through all the files...
	for( long i = 0; i < count; i++ )
	{
	
	    //Get database ref at position i;
		record_ref item = message->FindRef( "refs", i );
		
		//Check if its real...
		if( item.database >= 0 && item.record >= 0 )
		{
		
			//check to see if its a file....
			if( does_ref_conform( item, "File") )
			{
			
				//Now lets make us a file...
				BFile file;
				char *dispString = (char *)malloc(10);
				
				char fileType[5]; //filetypeLength +1
				char fileCreat[5]; //fileCreatLength +1
				
				
				
				(*dispString) = '\0';
				
				//set up a file object...
				file.SetRef(item);
				
				//Get file type and creator...
				file.GetTypeAndApp( (ulong *)fileType, (ulong *)fileCreat);
				
				fileType[4] = '\0';
				
				fileCreat[4] = '\0';
								
				strcat(dispString, fileType);
				strcat( dispString, " ");
				strcat( dispString, fileCreat);
				
				
				if ( resultWindow->Lock() )
				{
					
					resultView->SetMyString( dispString );
					
					resultView->Invalidate();
					
					resultWindow->Unlock();
				} //if Lock()
				
				else{beep(); beep(); beep(); return;}
			
			}
		
		}
	
	}

	
}

