/*
	
	HelloView.cpp
	
	Copyright 1995 Be Incorporated, All Rights Reserved.
	
	Modified by jeremy Moskovich 20-feb-96
	Jeremy@shape.co.il
*/

#ifndef HELLO_VIEW_H
#include "HelloView.h"
#endif

#include <string.h> //for strcpy()
#include <stdlib.h> //for malloc() & realloc()


HelloView::HelloView(BRect rect, char *name)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
	theString = (char *)malloc( strlen(name) + 1 );
					
	strcpy( theString, name );
}


void HelloView::AttachedToWindow()
{
	SetFontName("Times New Roman");
	SetFontSize(24);
}


void HelloView::Draw(BRect updateRect)
{
	 MovePenTo(BPoint(10, 30));
	DrawString(theString);
}

void HelloView::SetMyString( char *Str ) 
{ 

	theString = (char *)realloc(theString, ( strlen(Str) + 1 ));
					
	strcpy( theString, Str );
}